(function ($, root) {
    var SESSION_STORAGE_NAMESPACE = "crowd.usermanagement.flash.data.";
    var sessionStorageSupported = window.sessionStorage && window.sessionStorage.getItem;

    var makeInternalKey = function(key) {
        return SESSION_STORAGE_NAMESPACE + key;
    };

    var UMFlashData = {};

    UMFlashData.set = function (key, data) {
        if (sessionStorageSupported) {
            window.sessionStorage.setItem(makeInternalKey(key), JSON.stringify(data));
        }
    };

    UMFlashData.get = function (key) {
        if (!sessionStorageSupported) {
            return;
        }

        return JSON.parse(window.sessionStorage.getItem(makeInternalKey(key)));
    };

    UMFlashData.getOnce = function (key) {
        var data = UMFlashData.get(key);
        UMFlashData.remove(key);
        return data;
    };

    UMFlashData.remove = function (key) {
        if (!sessionStorageSupported) {
            return;
        }

        return window.sessionStorage.removeItem(makeInternalKey(key));
    };

    root.UMFlashData = UMFlashData;

})(AJS.$, window.UserManagement = window.UserManagement || {});