(function (um) {

    um.util = {
        /**
         * Replaces - with _ in object names so they can easily accessible via JavaScript
         * @param {Object} user with unsanitised param names
         * @returns {Object} user with sanitised param names
         */
        underscoreParamNames: function(user) {
            return _.object(_.map(user, function (value, key) {
                return [key.replace(/\-/g, '_'), value]
            }));
        }
    }

})(window.UserManagement = window.UserManagement || {});
