(function($, root) {
    root.manipulation = root.manipulation || {};

    root.manipulation.groups = {
        // Used for removing a user from a group on both the users detail page and the groups detail page.
        setupUserRemovalFromGroup: function (options) {

            options = $.extend({}, options);

            $(options.table).on("click", ".remove-membership", function () {
                // If details are not present, they're available as "data-" attributes.
                var groupName = options.groupName || $(this).data("groupname");
                var userName = options.userName || $(this).data("username");

                $(this)
                        .prop("disabled", true)
                        .after(usermanagement.loading());

                $.ajax(AJS.contextPath() + "/rest/um/1/user/group/direct?username=" + encodeURIComponent(userName) + "&groupname=" + encodeURIComponent(groupName), {
                    type: "delete"
                }).fail(function (jqXhr) {
                    try {
                        new root.UMFlashMessage("error", {
                            title: JSON.parse(jqXhr.responseText).errors[0].message
                        });
                    } catch (e) {
                        new root.UMFlashMessage("error", {
                            title: AJS.I18n.getText("usermanagement.user.remove.membership.failure", userName, groupName)
                        });
                    }

                    options.completed && options.completed(groupName, userName);
                }).done(function () {
                    new root.UMFlashMessage("success", {
                        title: AJS.I18n.getText("usermanagement.user.remove.membership.success", userName, groupName)
                    });

                    options.completed && options.completed(groupName, userName);

                });
            });
        }
    };
})(AJS.$, window.UserManagement = window.UserManagement || {});