/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.license;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public enum LicenseableApplication {
    CROWD("crowd", "/crowd"),
    JIRA("jira", ""),
    CONFLUENCE("confluence", "/wiki"),
    BAMBOO("bamboo", "/builds");

    public static final Set<LicenseableApplication> NON_CROWD_APPLICATIONS;
    private final String applicationName;
    private final String context;
    public static final Function<LicenseableApplication, String> NAME_FUNCTION;

    private LicenseableApplication(String applicationName, String context) {
        this.applicationName = applicationName;
        this.context = context;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getNotificationUri(String endpoint) throws IllegalStateException {
        if (this.context == null) {
            throw new IllegalStateException("Should not be attempting to create Webhooks for product: " + this.getApplicationName());
        }
        return this.context + endpoint;
    }

    public static Predicate<LicenseableApplication> nameFilterIgnoreCase(final String applicationName) {
        return new Predicate<LicenseableApplication>(){

            public boolean apply(LicenseableApplication licenseableApplication) {
                return StringUtils.equalsIgnoreCase(applicationName, licenseableApplication.getApplicationName());
            }
        };
    }

    static {
        NON_CROWD_APPLICATIONS = Sets.difference(EnumSet.allOf(LicenseableApplication.class), (Set)ImmutableSet.of((Object)((Object)CROWD)));
        NAME_FUNCTION = new Function<LicenseableApplication, String>(){

            public String apply(LicenseableApplication licenseableApplication) {
                return licenseableApplication.getApplicationName();
            }
        };
    }
}

