/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.license;

import com.atlassian.util.license.LicenseChangeListener;
import com.atlassian.util.license.LicenseChangedEvent;
import com.atlassian.util.license.LicenseFileListener;
import com.atlassian.util.license.LicenseFileParser;
import com.atlassian.util.license.LicenseMonitorService;
import com.atlassian.util.license.LicenseableApplication;
import com.atlassian.util.license.LicensedApplicationSource;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LicenseMonitorServiceImpl
implements LicenseMonitorService,
LicensedApplicationSource {
    private static final Logger log = LoggerFactory.getLogger(LicenseMonitorServiceImpl.class);
    private static final String LICENSE_DIRECTORY_SYSPROP = "horde.license.directory";
    private static final String LICENSE_POLL_DELAY_SYSPROP = "horde.license.delay";
    private static final String DEFAULT_LICENSE_DIRECTORY = "/data/jirastudio/home/";
    static final String LICENSE_FILE = "studio.license";
    private static final long DEFAULT_LICENSE_DELAY = TimeUnit.MINUTES.toMillis(5L);
    private static final String LICENSE_DIRECTORY = System.getProperty("horde.license.directory", "/data/jirastudio/home/");
    private static final Long POLLING_DELAY_MS = Long.getLong("horde.license.delay", DEFAULT_LICENSE_DELAY);
    private final List<LicenseChangeListener> listeners = new CopyOnWriteArrayList<LicenseChangeListener>();
    private final LicenseFileListener licenseFileListener;
    private final DefaultFileMonitor fileMonitor;

    public LicenseMonitorServiceImpl(LicenseFileParser licenseFileParser) {
        this.licenseFileListener = new LicenseFileListener(this, licenseFileParser);
        this.fileMonitor = new DefaultFileMonitor(this.licenseFileListener);
    }

    public void startMonitoring() {
        log.info("Starting the monitoring of the license file.");
        this.ensureLicenseFileMonitored();
        this.fileMonitor.setDelay(POLLING_DELAY_MS);
        this.fileMonitor.setChecksPerRun(0);
        this.fileMonitor.setRecursive(true);
        this.fileMonitor.start();
        log.info("Reading the license file and kicking an initial license notification off.");
        this.licenseFileListener.readAndNotifyFromFile(new File(LICENSE_DIRECTORY, LICENSE_FILE));
    }

    public void setListeners(List<LicenseChangeListener> listeners) {
        for (LicenseChangeListener listener : listeners) {
            this.registerListener(listener);
        }
    }

    private void ensureLicenseFileMonitored() {
        try {
            FileSystemManager manager = VFS.getManager();
            FileObject licenseFile = manager.resolveFile(LICENSE_DIRECTORY);
            this.fileMonitor.addFile(licenseFile);
        }
        catch (FileSystemException e) {
            log.error("Could not monitor the license.", (Throwable)e);
        }
    }

    @Override
    public Optional<LicenseChangedEvent> getLastChangedEvent() {
        return Optional.fromNullable((Object)this.licenseFileListener.getLastChangedEvent());
    }

    @Override
    public synchronized void registerListener(LicenseChangeListener licenseChangeListener) {
        this.listeners.add(licenseChangeListener);
        LicenseChangedEvent lastChangedEvent = this.licenseFileListener.getLastChangedEvent();
        if (lastChangedEvent != null) {
            licenseChangeListener.onUpdate(lastChangedEvent);
        } else {
            log.debug("A listener was added but it was not notified about the license status (because we don't know what license is present).");
        }
    }

    @Override
    public synchronized void forceNotification() {
        LicenseChangedEvent lastChangedEvent = this.licenseFileListener.getLastChangedEvent();
        if (lastChangedEvent != null) {
            for (LicenseChangeListener listener : this.listeners) {
                listener.onUpdate(lastChangedEvent);
            }
        } else {
            log.error("There was no previous LicenseChangedEvent, nobody will be notified and this may cause problems.");
        }
    }

    @VisibleForTesting
    LicenseFileListener getLicenseFileListener() {
        return this.licenseFileListener;
    }

    @Override
    public Set<LicenseableApplication> licensedApplications() {
        return ((LicenseChangedEvent)this.getLastChangedEvent().get()).getLicensedApps();
    }
}

