/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.license;

import com.atlassian.extras.api.AtlassianLicense;
import com.atlassian.extras.api.LicenseException;
import com.atlassian.extras.api.LicenseManager;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.ProductLicense;
import com.atlassian.util.license.LicenseChangedEvent;
import com.atlassian.util.license.LicenseableApplication;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseFileParser {
    private static final Logger log = LoggerFactory.getLogger(LicenseFileParser.class);
    private final LicenseManager licenseManager;

    public LicenseFileParser(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<LicenseChangedEvent> parseLicenseFile(InputStream inputStream) {
        Optional optional;
        try {
            AtlassianLicense license = this.licenseManager.getLicense(IOUtils.toString(inputStream));
            Optional firstProduct = Optional.fromNullable((Object)Iterables.getFirst(license.getProductLicenses(), null));
            if (!firstProduct.isPresent()) {
                log.error("There were no products in the license file. Licenses are missing. Treating this as a missing license file.");
                Optional optional2 = Optional.absent();
                return optional2;
            }
            Set<LicenseableApplication> licenseableApplications = this.getLicenseableApplications(license);
            Optional optional3 = Optional.of((Object)new LicenseChangedEvent(licenseableApplications, (Optional<ProductLicense>)firstProduct));
            return optional3;
        }
        catch (LicenseException e) {
            log.error("Failed to parse the encoded license.", (Throwable)e);
            optional = Optional.absent();
            return optional;
        }
        catch (IOException e) {
            log.error("Encountered an IO error when attempting to read the license file.", (Throwable)e);
            optional = Optional.absent();
            return optional;
        }
        finally {
            Closeables.closeQuietly((Closeable)inputStream);
        }
    }

    private Set<LicenseableApplication> getLicenseableApplications(AtlassianLicense license) {
        ImmutableSet.Builder licenseableApplications = ImmutableSet.builder();
        if (LicenseFileParser.productActive(license, Product.JIRA)) {
            licenseableApplications.add((Object)LicenseableApplication.JIRA);
        }
        if (LicenseFileParser.productActive(license, Product.CONFLUENCE)) {
            licenseableApplications.add((Object)LicenseableApplication.CONFLUENCE);
        }
        if (LicenseFileParser.productActive(license, Product.BAMBOO)) {
            licenseableApplications.add((Object)LicenseableApplication.BAMBOO);
        }
        if (LicenseFileParser.productActive(license, Product.CROWD)) {
            licenseableApplications.add((Object)LicenseableApplication.CROWD);
        }
        return licenseableApplications.build();
    }

    private static boolean productActive(AtlassianLicense license, Product product) {
        ProductLicense potentialProductLicense = license.getProductLicense(product);
        return potentialProductLicense != null && potentialProductLicense.getProperty("active").equals("true");
    }
}

