/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.license;

import com.atlassian.util.license.LicenseChangedEvent;
import com.atlassian.util.license.LicenseFileParser;
import com.atlassian.util.license.LicenseMonitorService;
import com.atlassian.util.license.LicenseMonitorServiceImpl;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LicenseFileListener
implements FileListener {
    private static final Logger log = LoggerFactory.getLogger(LicenseFileListener.class);
    private volatile LicenseChangedEvent lastChangedEvent;
    private final LicenseMonitorService licenseMonitorService;
    private final LicenseFileParser licenseFileParser;

    public LicenseFileListener(LicenseMonitorServiceImpl licenseMonitorService, LicenseFileParser licenseFileParser) {
        this.licenseMonitorService = licenseMonitorService;
        this.licenseFileParser = licenseFileParser;
        this.lastChangedEvent = null;
    }

    public LicenseChangedEvent getLastChangedEvent() {
        return this.lastChangedEvent;
    }

    @Override
    public void fileCreated(FileChangeEvent fileChangeEvent) throws Exception {
        if (LicenseFileListener.isLicenseFile(fileChangeEvent)) {
            log.info("{} was created.", (Object)fileChangeEvent.getFile().getName());
            this.readAndNotifyFromEvent(fileChangeEvent);
        }
    }

    @Override
    public void fileDeleted(FileChangeEvent fileChangeEvent) throws Exception {
        if (LicenseFileListener.isLicenseFile(fileChangeEvent)) {
            FileName fileName = fileChangeEvent.getFile().getName();
            if (this.lastChangedEvent == null) {
                log.error("{} was deleted. We have no idea what the license is supposed to be and nothing will be notified as a result.", (Object)fileName);
            } else {
                log.warn("The file {} was deleted but we still retain the last read license in memory.", (Object)fileName);
            }
        }
    }

    @Override
    public void fileChanged(FileChangeEvent fileChangeEvent) throws Exception {
        if (LicenseFileListener.isLicenseFile(fileChangeEvent)) {
            log.info("{} was modified.", (Object)fileChangeEvent.getFile().getName());
            this.readAndNotifyFromEvent(fileChangeEvent);
        }
    }

    private static boolean isLicenseFile(FileChangeEvent fileChangeEvent) {
        return fileChangeEvent.getFile().getName().getBaseName().equals("studio.license");
    }

    @VisibleForTesting
    synchronized void readAndNotify(InputStream inputStream) {
        Optional<LicenseChangedEvent> potentialLicense = this.licenseFileParser.parseLicenseFile(inputStream);
        if (potentialLicense.isPresent()) {
            this.notifyOnChange((LicenseChangedEvent)potentialLicense.get());
        }
    }

    private synchronized void notifyOnChange(LicenseChangedEvent newLicense) {
        Preconditions.checkNotNull((Object)newLicense);
        if (newLicense.equals(this.lastChangedEvent)) {
            log.debug("The set of licensed applications remains unchanged. Notifying nobody.");
        } else {
            log.info("The set of licensed applications has changed. Notifying all listeners.");
            this.lastChangedEvent = newLicense;
            this.licenseMonitorService.forceNotification();
        }
    }

    private void readAndNotifyFromEvent(FileChangeEvent fileChangeEvent) throws FileSystemException {
        this.readAndNotify(fileChangeEvent.getFile().getContent().getInputStream());
    }

    public void readAndNotifyFromFile(File licenseFile) {
        try {
            this.readAndNotify(new FileInputStream(licenseFile));
        }
        catch (FileNotFoundException e) {
            log.error("Important, we could not read the license file: {}", (Object)licenseFile.getAbsolutePath(), (Object)e);
        }
    }
}

