/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.license;

import com.atlassian.extras.api.ProductLicense;
import com.atlassian.util.license.LicenseableApplication;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class LicenseChangedEvent {
    public static final LicenseChangedEvent NO_APPS = new LicenseChangedEvent((Set<LicenseableApplication>)ImmutableSet.of(), (Optional<ProductLicense>)Optional.absent());
    private final Set<LicenseableApplication> licensedApps;
    private static final String SEN_KEY = "SEN";
    private static final String EXTERNAL_UUID_KEY = "externalUuid";
    private final Optional<String> sen;
    private final Optional<String> externalUuid;

    public LicenseChangedEvent(Set<LicenseableApplication> licensedApps, Optional<ProductLicense> anyProductLicense) {
        Preconditions.checkNotNull(licensedApps);
        this.licensedApps = ImmutableSet.copyOf(licensedApps);
        if (anyProductLicense.isPresent()) {
            ProductLicense productLicense = (ProductLicense)anyProductLicense.get();
            this.sen = Optional.fromNullable((Object)productLicense.getProperty(SEN_KEY));
            this.externalUuid = Optional.fromNullable((Object)productLicense.getProperty(EXTERNAL_UUID_KEY));
        } else {
            this.sen = Optional.absent();
            this.externalUuid = Optional.absent();
        }
    }

    public Set<LicenseableApplication> getLicensedApps() {
        return this.licensedApps;
    }

    public Optional<String> getSEN() {
        return this.sen;
    }

    public Optional<String> getExternalUUID() {
        return this.externalUuid;
    }
}

