/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.web;

import com.atlassian.crowd.plugin.usermanagement.web.Router;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class DefaultRouter
implements Router {
    private final Map<String, Router.Page> routes;
    private final Function<String, Option<Router.Page>> getRoute = new Function<String, Option<Router.Page>>(){

        public Option<Router.Page> apply(String slug) {
            return Option.option(DefaultRouter.this.routes.get(slug));
        }
    };
    private final Supplier<Router.Page> defaultPage = new Supplier<Router.Page>(){

        public Router.Page get() {
            return (Router.Page)DefaultRouter.this.routes.get("groups");
        }
    };

    public DefaultRouter() {
        this.routes = ImmutableMap.of((Object)"users", (Object)new Router.Page("users", "usermanagement.users.nav"), (Object)"groups", (Object)new Router.Page("groups", "usermanagement.groups.nav"), (Object)"apps", (Object)new Router.Page("apps", "usermanagement.apps.nav"), (Object)"accessconfig", (Object)new Router.Page("accessconfig", "usermanagement.accessconfig.nav"));
    }

    @Override
    public Router.Page route(HttpServletRequest request) {
        return this.getSlug(request).flatMap(this.getRoute).getOrElse(this.defaultPage);
    }

    private Option<String> getSlug(HttpServletRequest request) {
        String[] pathElements = request.getPathInfo().split("/");
        return pathElements.length >= 3 ? Option.some(pathElements[2]) : Option.none(String.class);
    }
}

