/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.util;

import com.atlassian.crowd.plugin.usermanagement.rest.util.CachePolicies;
import java.net.URI;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;

public class ResponseFactory {
    private static Response.ResponseBuilder applyDefaults(Response.ResponseBuilder builder) {
        return builder.cacheControl(CachePolicies.never()).header("Vary", (Object)"X-AUSERNAME").header("Vary", (Object)"Cookie");
    }

    public static Response.ResponseBuilder ok() {
        return ResponseFactory.applyDefaults(Response.ok());
    }

    public static Response.ResponseBuilder ok(Object entity) {
        return ResponseFactory.applyDefaults(Response.ok((Object)entity));
    }

    public static Response.ResponseBuilder ok(Object entity, CacheControl cacheControl) {
        return ResponseFactory.applyDefaults(Response.ok((Object)entity)).cacheControl(cacheControl);
    }

    public static Response.ResponseBuilder created(URI location) {
        return ResponseFactory.applyDefaults(Response.created((URI)location));
    }

    public static Response.ResponseBuilder noContent() {
        return ResponseFactory.applyDefaults(Response.noContent());
    }

    public static Response.ResponseBuilder status(Response.Status status) {
        return ResponseFactory.applyDefaults(Response.status((Response.Status)status));
    }

    public static Response.ResponseBuilder serverError() {
        return ResponseFactory.applyDefaults(Response.serverError());
    }
}

