/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.host;

import com.atlassian.crowd.plugin.usermanagement.userprovisioning.AccessLevel;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.ConfigurationEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.GroupAttributesEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.LicenseInformationEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.PermissionEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.host.HostAdminEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.host.HostDescriptionEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.host.HostLicensingEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.host.HostProductEntity;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class HostEntity {
    @JsonProperty
    private final HostDescriptionEntity description;
    @JsonProperty
    private final HostAdminEntity administration;
    @JsonProperty
    private final HostLicensingEntity licensing;
    @JsonProperty
    private final List<HostProductEntity> products;

    @JsonCreator
    public HostEntity(@JsonProperty(value="description") HostDescriptionEntity description, @JsonProperty(value="administration") HostAdminEntity administration, @JsonProperty(value="licensing") HostLicensingEntity licensing, @JsonProperty(value="products") List<HostProductEntity> products) {
        this.description = description;
        this.administration = administration;
        this.licensing = licensing;
        this.products = products;
    }

    public HostDescriptionEntity getDescription() {
        return this.description;
    }

    public HostAdminEntity getAdministration() {
        return this.administration;
    }

    public HostLicensingEntity getLicensing() {
        return this.licensing;
    }

    public List<HostProductEntity> getProducts() {
        return this.products;
    }

    public static HostEntity sample() throws URISyntaxException {
        PermissionEntity users = HostEntity.samplePermissions("users", true);
        PermissionEntity admins = HostEntity.samplePermissions("admins", true);
        PermissionEntity sysadmins = HostEntity.samplePermissions("sysadmins", true);
        ImmutableSet canLogin = ImmutableSet.of((Object)((Object)AccessLevel.ADMIN), (Object)((Object)AccessLevel.SYSADMIN));
        HostProductEntity serviceDesk = new HostProductEntity("jira.servicedesk", "JIRA Service Desk", false, 10, users, "/secure/admin/GlobalPermissions!default.jspa");
        HostProductEntity software = new HostProductEntity("jira.software", "JIRA Software", false, 10, users, "/secure/admin/GlobalPermissions!default.jspa");
        return new HostEntity(new HostDescriptionEntity("samplehost", "sample", new URI("http://sample.com"), new URI("http://sample.com")), new HostAdminEntity((Set<AccessLevel>)canLogin, (Map<AccessLevel, PermissionEntity>)ImmutableMap.of((Object)((Object)AccessLevel.ADMIN), (Object)admins, (Object)((Object)AccessLevel.SYSADMIN), (Object)sysadmins)), new HostLicensingEntity((Set<AccessLevel>)ImmutableSet.of((Object)((Object)AccessLevel.SYSADMIN)), (Set<String>)ImmutableSet.of((Object)"excluded")), (List<HostProductEntity>)ImmutableList.of((Object)new HostProductEntity("jira.platform", "JIRA platform", true, 5, users, "/secure/admin/GlobalPermissions!default.jspa"), (Object)serviceDesk, (Object)software));
    }

    public static HostEntity convert(String id, String name, URI displayURI, URI rpcURI, ConfigurationEntity configuration) throws Exception {
        PermissionEntity users = HostEntity.getDefaultIfNull(configuration.getPermissions().get((Object)AccessLevel.USE));
        PermissionEntity admins = HostEntity.getDefaultIfNull(configuration.getPermissions().get((Object)AccessLevel.ADMIN));
        PermissionEntity sysadmins = HostEntity.getDefaultIfNull(configuration.getPermissions().get((Object)AccessLevel.SYSADMIN));
        LicenseInformationEntity license = configuration.getLicenseInformation();
        HashSet<AccessLevel> canLogin = new HashSet<AccessLevel>(configuration.getCanLogin());
        return new HostEntity(new HostDescriptionEntity(id, name, displayURI, rpcURI), new HostAdminEntity(canLogin, (Map<AccessLevel, PermissionEntity>)ImmutableMap.of((Object)((Object)AccessLevel.ADMIN), (Object)admins, (Object)((Object)AccessLevel.SYSADMIN), (Object)sysadmins)), new HostLicensingEntity(license.getAccessLevelsExcludedFromCount(), license.getGroupsExcludedFromCount()), (List<HostProductEntity>)ImmutableList.of((Object)new HostProductEntity(id, name, true, license.getLimit(), users, configuration.getPermissionsPath())));
    }

    private static PermissionEntity getDefaultIfNull(PermissionEntity entity) {
        if (entity != null) {
            return entity;
        }
        return new PermissionEntity(new HashMap<String, GroupAttributesEntity>(), new ArrayList<String>());
    }

    private static PermissionEntity samplePermissions(String groupName, boolean isDefault) {
        return new PermissionEntity((Map<String, GroupAttributesEntity>)ImmutableMap.of((Object)groupName, (Object)new GroupAttributesEntity(isDefault)), new ArrayList<String>());
    }

    public static List<String> getProductIds(HostEntity hostEntity) {
        ArrayList<String> productIds = new ArrayList<String>();
        if (hostEntity != null) {
            for (HostProductEntity product : hostEntity.getProducts()) {
                productIds.add(product.getId());
            }
        }
        return productIds;
    }

    public HostProductEntity findPlatformProduct() {
        if (this.getProducts().size() == 1) {
            return this.getProducts().get(0);
        }
        for (HostProductEntity productEntity : this.getProducts()) {
            if (!productEntity.isPlatform()) continue;
            return productEntity;
        }
        throw new RuntimeException("All hosts must contain a platform product");
    }
}

