/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity;

import com.atlassian.plugins.rest.common.Link;
import com.google.common.base.Function;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class ValidationMessageEntity {
    @JsonProperty
    private final String message;
    @JsonProperty
    private final Link link;
    private static final Function<String, ValidationMessageEntity> NEW_VALIDATION_MESSAGE_ENTITY_FUNCTION = new Function<String, ValidationMessageEntity>(){

        public ValidationMessageEntity apply(String messageText) {
            return new ValidationMessageEntity(messageText);
        }
    };
    private static final Function<ValidationMessageEntity, String> GET_MESSAGE_FUNCTION = new Function<ValidationMessageEntity, String>(){

        public String apply(ValidationMessageEntity messageEntity) {
            return messageEntity.getMessage();
        }
    };

    public ValidationMessageEntity(String message) {
        this(message, null);
    }

    @JsonCreator
    public ValidationMessageEntity(@JsonProperty(value="message") String message, @JsonProperty(value="link") Link link) {
        this.message = message;
        this.link = link;
    }

    public String getMessage() {
        return this.message;
    }

    public Link getLink() {
        return this.link;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationMessageEntity that = (ValidationMessageEntity)o;
        if (this.link != null ? !this.link.equals((Object)that.link) : that.link != null) {
            return false;
        }
        return this.message.equals(that.message);
    }

    public int hashCode() {
        int result = this.message.hashCode();
        result = 31 * result + (this.link != null ? this.link.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ValidationMessageEntity{link=" + this.link + ", message='" + this.message + '\'' + '}';
    }

    public static Function<String, ValidationMessageEntity> newValidationMessageEntityFunction() {
        return NEW_VALIDATION_MESSAGE_ENTITY_FUNCTION;
    }

    public static Function<ValidationMessageEntity, String> getMessageFunction() {
        return GET_MESSAGE_FUNCTION;
    }
}

