/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity;

import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.GroupAttributesEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class PermissionEntity {
    @JsonProperty
    private final Map<String, GroupAttributesEntity> groups;
    @JsonProperty
    private final List<String> users;

    @JsonCreator
    public PermissionEntity(@JsonProperty(value="groups") Map<String, GroupAttributesEntity> groups, @JsonProperty(value="users") List<String> users) {
        this.groups = groups;
        this.users = users;
    }

    public Map<String, GroupAttributesEntity> getGroups() {
        return this.groups;
    }

    public List<String> getUsers() {
        return this.users;
    }

    public static PermissionEntity duplicateWithGroups(PermissionEntity entity, List<String> adminGroups) {
        String defaultGroup = null;
        for (String group : entity.groups.keySet()) {
            if (!entity.groups.get(group).isDefault()) continue;
            defaultGroup = group;
        }
        HashMap<String, GroupAttributesEntity> newGroups = new HashMap<String, GroupAttributesEntity>();
        for (String newGroup : adminGroups) {
            newGroups.put(newGroup, new GroupAttributesEntity(newGroup.equals(defaultGroup)));
        }
        return new PermissionEntity(newGroups, entity.users);
    }
}

