/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.task;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkFilteringService;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialiseDefaultAppsTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitialiseDefaultAppsTask.class);
    private final UserProvisioningService provisioningService;
    private final ApplicationLinkFilteringService applicationLinkFilteringService;
    private final PluginSettings globalSettings;
    private static final String INITIALISED = "atlassian.usermanagement.initialised.default.apps";

    public InitialiseDefaultAppsTask(UserProvisioningService provisioningService, ApplicationLinkFilteringService applicationLinkFilteringService, PluginSettingsFactory pluginSettingsFactory) {
        this.provisioningService = provisioningService;
        this.applicationLinkFilteringService = applicationLinkFilteringService;
        this.globalSettings = pluginSettingsFactory.createGlobalSettings();
    }

    @PostConstruct
    public void onStart() {
        boolean initialised;
        boolean bl = initialised = this.globalSettings.get(INITIALISED) != null;
        if (!initialised) {
            LOGGER.info("Initialising default apps");
            HashMap<ReadOnlyApplicationLink, Boolean> defaults = new HashMap<ReadOnlyApplicationLink, Boolean>();
            for (ReadOnlyApplicationLink link : this.applicationLinkFilteringService.getApplicationLinks()) {
                LOGGER.info("Adding " + link.getName() + " as default app");
                defaults.put(link, true);
            }
            this.provisioningService.updateApplicationDefaults(defaults);
            this.globalSettings.put(INITIALISED, (Object)"true");
            LOGGER.info("Default apps initialised");
        }
    }
}

