/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service.validation;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.plugin.usermanagement.service.ReadOnlyApplicationLinkWithConfig;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.validation.LicenseExceeded;
import com.atlassian.crowd.plugin.usermanagement.service.validation.MembershipChangeCausingLicenseExceeded;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.ConfigurationEntity;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LicenseExceededCheckFunction
implements Function<ReadOnlyApplicationLinkWithConfig, Option<MembershipChangeCausingLicenseExceeded>> {
    private final Set<String> groups;
    private final Map<String, Set<String>> groupsToExistingUsers;
    private final Map<String, Set<String>> groupsToUsersToAdd;
    private final UserProvisioningService userProvisioningService;

    public LicenseExceededCheckFunction(Set<String> groups, Map<String, Set<String>> groupsToExistingUsers, Map<String, Set<String>> groupsToUsersToAdd, UserProvisioningService userProvisioningService) {
        this.groups = groups;
        this.groupsToExistingUsers = groupsToExistingUsers;
        this.groupsToUsersToAdd = groupsToUsersToAdd;
        this.userProvisioningService = userProvisioningService;
    }

    public Option<MembershipChangeCausingLicenseExceeded> apply(ReadOnlyApplicationLinkWithConfig applicationLink) {
        Option<Integer> potentialSeatsAvailable;
        if (applicationLink.getConfig().isLeft()) {
            return Option.none();
        }
        ConfigurationEntity configurationEntity = (ConfigurationEntity)applicationLink.getConfig().right().get();
        try {
            potentialSeatsAvailable = this.userProvisioningService.getAvailableSeatsForApplication(configurationEntity);
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (OperationFailedException e) {
            throw new RuntimeException(e);
        }
        if (potentialSeatsAvailable.isEmpty()) {
            return Option.none();
        }
        Integer seatsAvailable = (Integer)potentialSeatsAvailable.get();
        Set<String> loginGroups = this.userProvisioningService.getAllLoginGroups(configurationEntity);
        Set<String> usersWithDirectAccess = this.userProvisioningService.getAllLoginUsers(configurationEntity);
        Sets.SetView loginGroupsToAdd = Sets.intersection(loginGroups, this.groups);
        if (!loginGroupsToAdd.isEmpty()) {
            HashSet usersWithGroupAccess = new HashSet();
            HashSet usersGainingAccessGroup = new HashSet();
            for (String group : loginGroups) {
                if (this.groupsToExistingUsers.containsKey(group)) {
                    usersWithGroupAccess.addAll(this.groupsToExistingUsers.get(group));
                }
                if (!this.groupsToUsersToAdd.containsKey(group)) continue;
                usersGainingAccessGroup.addAll(this.groupsToUsersToAdd.get(group));
            }
            Sets.SetView usersGainingAccess = Sets.difference(usersGainingAccessGroup, (Set)Sets.union(usersWithGroupAccess, usersWithDirectAccess));
            int seatsRequired = usersGainingAccess.size();
            if (seatsRequired > seatsAvailable) {
                return Option.some(new MembershipChangeCausingLicenseExceeded((Set<String>)usersGainingAccess, (Set<String>)loginGroupsToAdd, new LicenseExceeded(seatsRequired, seatsAvailable)));
            }
        }
        return Option.none();
    }
}

