/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.BulkAddResult;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.SeatsEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ApplicationAccessChangeNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.SysadminGroupModificationNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.UserModificationNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkFilteringService;
import com.atlassian.crowd.plugin.usermanagement.service.ConfigurationEntityFunctions;
import com.atlassian.crowd.plugin.usermanagement.service.ConflictingConfiguration;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.plugin.usermanagement.service.GrantAppAccessResult;
import com.atlassian.crowd.plugin.usermanagement.service.ReadOnlyApplicationLinkWithConfig;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupCheckService;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.validation.Failure;
import com.atlassian.crowd.plugin.usermanagement.service.validation.GrantingUseAccessSideEffect;
import com.atlassian.crowd.plugin.usermanagement.service.validation.IntertwinedConfiguration;
import com.atlassian.crowd.plugin.usermanagement.service.validation.LicenseExceeded;
import com.atlassian.crowd.plugin.usermanagement.service.validation.RevokingUseAccessSideEffect;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ValidationResults;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.AccessLevel;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.ConfigurationEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.GroupAttributesEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.LicenseInformationEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.PermissionEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.util.ImmutableMapUtils;
import com.atlassian.crowd.plugin.usermanagement.util.QueryUtils;
import com.atlassian.crowd.plugin.usermanagement.util.ServiceDeskValidationFunctions;
import com.atlassian.crowd.plugin.usermanagement.util.UserAndGroupCheckServiceFunctions;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserProvisioningServiceImpl
implements UserProvisioningService {
    private static final String USER_PROVISIONING_REST_URL_PERMISSION_USER = "/rest/userprovisioning/1/permission/%s/user/%s";
    private static final String DEFAULT_APP_PLUGIN_SETTINGS_KEY = "com.atlassian.crowd.plugin.usermanagement:default-apps:";
    private static final Logger log = LoggerFactory.getLogger(UserProvisioningServiceImpl.class);
    private final ApplicationLinkFilteringService applicationLinkFilteringService;
    private final UserAndGroupCheckService userAndGroupCheckService;
    private final DirectoryLocator directoryLocator;
    private final DirectoryManager directoryManager;
    private final PluginSettings pluginSettings;
    private final Predicate<ReadOnlyApplicationLink> IS_DEFAULT_APPLICATION = new Predicate<ReadOnlyApplicationLink>(){

        public boolean apply(ReadOnlyApplicationLink applicationLink) {
            return UserProvisioningServiceImpl.this.isDefaultApplication(applicationLink);
        }
    };
    private final Function<ReadOnlyApplicationLink, Boolean> TO_APPLICATION_DEFAULTS_ENTITY = new Function<ReadOnlyApplicationLink, Boolean>(){

        public Boolean apply(ReadOnlyApplicationLink applicationLink) {
            return UserProvisioningServiceImpl.this.isDefaultApplication(applicationLink);
        }
    };

    UserProvisioningServiceImpl(ApplicationLinkFilteringService applicationLinkFilteringService, UserAndGroupCheckService userAndGroupCheckService, DirectoryLocator directoryLocator, DirectoryManager directoryManager, PluginSettingsFactory pluginSettingsFactory) {
        this.applicationLinkFilteringService = applicationLinkFilteringService;
        this.userAndGroupCheckService = userAndGroupCheckService;
        this.directoryLocator = directoryLocator;
        this.directoryManager = directoryManager;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    @Override
    public SeatsEntity getSeatsEntityForApplication(ConfigurationEntity configurationEntity) throws DirectoryNotFoundException, OperationFailedException {
        Supplier<Set<String>> grantedUsers = this.findUsersGrantedAccessToApplicationSupplier(configurationEntity);
        Option<Integer> available = this.calculateAvailableSeats(configurationEntity, grantedUsers);
        int used = this.calculateUsedSeats(configurationEntity, grantedUsers);
        boolean isUnlimited = available.isEmpty();
        return new SeatsEntity(available, used, isUnlimited);
    }

    @Override
    public Option<Integer> getAvailableSeatsForApplication(ConfigurationEntity configurationEntity) throws DirectoryNotFoundException, OperationFailedException {
        return this.getSeatsEntityForApplication(configurationEntity).getAvailable();
    }

    @Override
    public Integer getUserCountForApplication(ConfigurationEntity configurationEntity) throws DirectoryNotFoundException, OperationFailedException {
        return this.getSeatsEntityForApplication(configurationEntity).getUsed();
    }

    private Option<Integer> calculateAvailableSeats(ConfigurationEntity configurationEntity, Supplier<Set<String>> grantedUsers) throws DirectoryNotFoundException, OperationFailedException {
        return UserProvisioningServiceImpl.calculateAvailableSeats(configurationEntity, grantedUsers, this.directoryManager, this.directoryLocator);
    }

    private int calculateUsedSeats(ConfigurationEntity configurationEntity, Supplier<Set<String>> grantedUsers) throws DirectoryNotFoundException, OperationFailedException {
        return UserProvisioningServiceImpl.calculateUsedSeats(configurationEntity, grantedUsers, this.directoryManager, this.directoryLocator);
    }

    @Override
    public Map<ReadOnlyApplicationLink, AccessLevel> getAccessLevel(String username, Map<ReadOnlyApplicationLink, ConfigurationEntity> appConfigs) throws DirectoryNotFoundException, OperationFailedException {
        return UserProvisioningServiceImpl.calculateAccessLevel(Option.some(username), this.getGroupsForUser(username), appConfigs);
    }

    @Override
    public Set<String> getAllLoginGroups(ConfigurationEntity configurationEntity) {
        return UserProvisioningServiceImpl.getGroupsForAccessLevels(configurationEntity, configurationEntity.getCanLogin());
    }

    @Override
    public Set<String> getAllLoginUsers(ConfigurationEntity configurationEntity) {
        return UserProvisioningServiceImpl.getIndividualsForAccessLevels(configurationEntity, configurationEntity.getCanLogin());
    }

    @Override
    public Collection<IntertwinedConfiguration> detectIntertwinedConfigurations(Map<ReadOnlyApplicationLink, ConfigurationEntity> appConfigs) {
        ImmutableList.Builder conflicts = ImmutableList.builder();
        HashSet checked = Sets.newHashSet();
        for (ReadOnlyApplicationLink outerLink : appConfigs.keySet()) {
            ConfigurationEntity outerConfig = appConfigs.get(outerLink);
            Set<String> outerDefaultUsersGroups = UserProvisioningServiceImpl.getDefaultUsersGroups(outerConfig);
            Sets.SetView outerLoginGroups = Sets.difference(this.getAllLoginGroups(outerConfig), UserProvisioningServiceImpl.getAllGroupsExcludedFromLicenseCounting(outerConfig));
            for (ReadOnlyApplicationLink innerLink : appConfigs.keySet()) {
                Sets.SetView loginGroupsOverlap;
                Sets.SetView defaultUseOverlapForInner;
                if (outerLink.equals(innerLink) || checked.contains(Pair.pair(innerLink, outerLink))) continue;
                ConfigurationEntity innerConfig = appConfigs.get(innerLink);
                Set<String> innerDefaultUsersGroups = UserProvisioningServiceImpl.getDefaultUsersGroups(innerConfig);
                Sets.SetView innerLoginGroups = Sets.difference(this.getAllLoginGroups(innerConfig), UserProvisioningServiceImpl.getAllGroupsExcludedFromLicenseCounting(outerConfig));
                Sets.SetView defaultUseOverlapForOuter = Sets.intersection(outerDefaultUsersGroups, (Set)innerLoginGroups);
                if (!defaultUseOverlapForOuter.isEmpty()) {
                    conflicts.add((Object)new GrantingUseAccessSideEffect(outerLink, innerLink, (Iterable<String>)defaultUseOverlapForOuter));
                }
                if (!(defaultUseOverlapForInner = Sets.intersection(innerDefaultUsersGroups, (Set)outerLoginGroups)).isEmpty()) {
                    conflicts.add((Object)new GrantingUseAccessSideEffect(innerLink, outerLink, (Iterable<String>)defaultUseOverlapForInner));
                }
                if (!(loginGroupsOverlap = Sets.intersection((Set)outerLoginGroups, (Set)innerLoginGroups)).isEmpty()) {
                    conflicts.add((Object)new RevokingUseAccessSideEffect(outerLink, innerLink, (Iterable<String>)loginGroupsOverlap));
                }
                checked.add(Pair.pair(outerLink, innerLink));
            }
        }
        return conflicts.build();
    }

    @Override
    public Either<ConflictingConfiguration, Set<String>> updateAccessLevel(String username, Map<ReadOnlyApplicationLink, AccessLevel> targetAccessLevels, boolean bypassValidation, Map<ReadOnlyApplicationLink, ConfigurationEntity> appConfigs) throws DirectoryNotFoundException, OperationFailedException, UserNotFoundException, GroupNotFoundException, ReadOnlyGroupException, DirectoryPermissionException, CredentialsRequiredException, ResponseException {
        Set<String> groups = this.getGroupsForUser(username);
        Map<ReadOnlyApplicationLink, AccessLevel> originalAccessLevels = UserProvisioningServiceImpl.calculateAccessLevel(Option.some(username), groups, appConfigs);
        return this.updateAccessLevel(appConfigs, username, groups, originalAccessLevels, targetAccessLevels, bypassValidation);
    }

    @Override
    public Either<ConflictingConfiguration, Set<String>> updateUseAccessLevel(String username, Map<ReadOnlyApplicationLink, Boolean> targetUseAccessLevels, boolean bypassValidation, Map<ReadOnlyApplicationLink, ConfigurationEntity> appConfigs) throws DirectoryNotFoundException, OperationFailedException, UserNotFoundException, GroupNotFoundException, ReadOnlyGroupException, DirectoryPermissionException, CredentialsRequiredException, ResponseException {
        Set<String> groups = this.getGroupsForUser(username);
        Map<ReadOnlyApplicationLink, AccessLevel> originalAccessLevels = UserProvisioningServiceImpl.calculateAccessLevel(Option.some(username), groups, appConfigs);
        Map<ReadOnlyApplicationLink, AccessLevel> targetAccessLevels = this.calculateTargetUseAccessLevel(appConfigs, originalAccessLevels, targetUseAccessLevels);
        return this.updateAccessLevel(appConfigs, username, groups, originalAccessLevels, targetAccessLevels, bypassValidation);
    }

    @Override
    public Map<ReadOnlyApplicationLink, Either<Failure, GrantAppAccessResult>> grantApplicationAccess(Set<String> usernames, Iterable<ReadOnlyApplicationLinkWithConfig> applicationLinks) throws DirectoryNotFoundException, OperationFailedException {
        return this.grantApplicationAccessInternal(usernames, false, applicationLinks);
    }

    @Override
    public Map<ReadOnlyApplicationLink, Either<Failure, GrantAppAccessResult>> grantApplicationAccessAnonymously(Set<String> usernames, Iterable<ReadOnlyApplicationLinkWithConfig> applicationLinks) throws DirectoryNotFoundException, OperationFailedException {
        return this.grantApplicationAccessInternal(usernames, true, applicationLinks);
    }

    @Override
    public Either<Map<ReadOnlyApplicationLink, Failure>, UserProvisioningService.ReservedApplicationAccess> reserveApplicationAccess(int needed, Iterable<ReadOnlyApplicationLinkWithConfig> applicationLinks) {
        return this.grantApplicationAccessInternal(needed, false, applicationLinks);
    }

    @Override
    public Either<Map<ReadOnlyApplicationLink, Failure>, UserProvisioningService.ReservedApplicationAccess> reserveApplicationAccessAnonymously(int needed, Iterable<ReadOnlyApplicationLinkWithConfig> applicationLinks) {
        return this.grantApplicationAccessInternal(needed, true, applicationLinks);
    }

    private Either<Map<ReadOnlyApplicationLink, Failure>, UserProvisioningService.ReservedApplicationAccess> grantApplicationAccessInternal(final int needed, final boolean anon, Iterable<ReadOnlyApplicationLinkWithConfig> applicationLinks) {
        Function<ConfigurationEntity, Either<LicenseExceeded, Function<Set<String>, GrantAppAccessResult>>> grantFunctionGenerator = new Function<ConfigurationEntity, Either<LicenseExceeded, Function<Set<String>, GrantAppAccessResult>>>(){

            public Either<LicenseExceeded, Function<Set<String>, GrantAppAccessResult>> apply(ConfigurationEntity configurationEntity) {
                try {
                    return UserProvisioningServiceImpl.this.reserveApplicationAccessSeats(needed, anon, configurationEntity, (Supplier<Set<String>>)UserProvisioningServiceImpl.this.findUsersGrantedAccessToApplicationSupplier(configurationEntity));
                }
                catch (DirectoryNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (OperationFailedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        HashMap failures = new HashMap();
        final HashMap grantFunctions = Maps.newHashMap();
        for (ReadOnlyApplicationLinkWithConfig applicationLink : applicationLinks) {
            if (applicationLink.getConfig().isLeft()) {
                failures.put(applicationLink.getDelegate(), applicationLink.getConfig().left().get());
                continue;
            }
            Either licenseExceededOrGrantFunction = (Either)grantFunctionGenerator.apply(applicationLink.getConfig().right().get());
            if (licenseExceededOrGrantFunction.isLeft()) {
                failures.put(applicationLink, licenseExceededOrGrantFunction.left().get());
                continue;
            }
            grantFunctions.put(applicationLink, licenseExceededOrGrantFunction.right().get());
        }
        if (!failures.isEmpty()) {
            return Either.left(failures);
        }
        UserProvisioningService.ReservedApplicationAccess reservedApplicationAccess = new UserProvisioningService.ReservedApplicationAccess(){

            public Map<ReadOnlyApplicationLink, GrantAppAccessResult> apply(final Set<String> users) {
                return ImmutableMapUtils.transform(grantFunctions, new Function<ReadOnlyApplicationLinkWithConfig, ReadOnlyApplicationLink>(){

                    public ReadOnlyApplicationLink apply(ReadOnlyApplicationLinkWithConfig input) {
                        return input.getDelegate();
                    }
                }, new Function<Function<Set<String>, GrantAppAccessResult>, GrantAppAccessResult>(){

                    public GrantAppAccessResult apply(Function<Set<String>, GrantAppAccessResult> grantFunction) {
                        return (GrantAppAccessResult)grantFunction.apply((Object)users);
                    }
                });
            }
        };
        return Either.right(reservedApplicationAccess);
    }

    private Map<ReadOnlyApplicationLink, Either<Failure, GrantAppAccessResult>> grantApplicationAccessInternal(Set<String> usernames, boolean anonymous, Iterable<ReadOnlyApplicationLinkWithConfig> applicationLinks) throws DirectoryNotFoundException, OperationFailedException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ReadOnlyApplicationLinkWithConfig applicationLink : applicationLinks) {
            if (applicationLink.getConfig().isRight()) {
                Either<LicenseExceeded, GrantAppAccessResult> grantAccessResult = this.grantApplicationAccess(usernames, anonymous, (ConfigurationEntity)applicationLink.getConfig().right().get());
                Either errorOrGrantResult = grantAccessResult.isLeft() ? Either.left(grantAccessResult.left().get()) : Either.right(grantAccessResult.right().get());
                builder.put((Object)applicationLink, errorOrGrantResult);
                continue;
            }
            builder.put((Object)applicationLink, Either.left(applicationLink.getConfig().left().get()));
        }
        return builder.build();
    }

    @Override
    public Iterable<ReadOnlyApplicationLink> getDefaultApplications() {
        return com.google.common.collect.Iterables.filter(this.getAllApplicationLinks(), this.IS_DEFAULT_APPLICATION);
    }

    private Iterable<ReadOnlyApplicationLink> getAllApplicationLinks() {
        return this.applicationLinkFilteringService.getApplicationLinks();
    }

    @Override
    public Map<ReadOnlyApplicationLink, Boolean> getApplicationDefaults() {
        return ImmutableMapUtils.toMap(this.getAllApplicationLinks(), this.TO_APPLICATION_DEFAULTS_ENTITY);
    }

    @Override
    public void updateApplicationDefaults(Map<ReadOnlyApplicationLink, Boolean> applicationLinks) {
        for (Map.Entry<ReadOnlyApplicationLink, Boolean> entry : applicationLinks.entrySet()) {
            this.pluginSettings.put(UserProvisioningServiceImpl.defaultAppKeyFor(entry.getKey().getId().get()), (Object)entry.getValue().toString());
        }
    }

    private boolean isDefaultApplication(ReadOnlyApplicationLink applicationLink) {
        return Boolean.parseBoolean((String)this.pluginSettings.get(UserProvisioningServiceImpl.defaultAppKeyFor(applicationLink.getId().get())));
    }

    @VisibleForTesting
    static String defaultAppKeyFor(String applicationLinkId) {
        return DEFAULT_APP_PLUGIN_SETTINGS_KEY + applicationLinkId;
    }

    private static Option<Integer> calculateAvailableSeats(ConfigurationEntity configurationEntity, Supplier<Set<String>> grantedUsers, DirectoryManager directoryManager, DirectoryLocator directoryLocator) throws DirectoryNotFoundException, OperationFailedException {
        Option maybeLimit = (Option)ConfigurationEntityFunctions.toLicenseLimit().apply((Object)configurationEntity);
        if (maybeLimit.isDefined()) {
            int licenseLimit = (Integer)maybeLimit.get();
            int usedSeats = UserProvisioningServiceImpl.calculateUsedSeats(configurationEntity, grantedUsers, directoryManager, directoryLocator);
            return Option.some(licenseLimit - usedSeats);
        }
        return Option.none(Integer.class);
    }

    private static int calculateUsedSeats(ConfigurationEntity configurationEntity, Supplier<Set<String>> grantedUsers, DirectoryManager directoryManager, DirectoryLocator directoryLocator) throws DirectoryNotFoundException, OperationFailedException {
        Set<String> usersToBeExcludedFromSeatCount = UserProvisioningServiceImpl.getUsersToBeExcludedFromSeatCount(configurationEntity, directoryManager, directoryLocator);
        Sets.SetView usersWithSeatsToBeCounted = Sets.difference((Set)((Set)grantedUsers.get()), usersToBeExcludedFromSeatCount);
        return usersWithSeatsToBeCounted.size();
    }

    private static Set<String> getUsersToBeExcludedFromSeatCount(ConfigurationEntity configurationEntity, DirectoryManager directoryManager, DirectoryLocator directoryLocator) throws DirectoryNotFoundException, OperationFailedException {
        Set<String> excludedGroupsFromCount = UserProvisioningServiceImpl.getAllGroupsExcludedFromLicenseCounting(configurationEntity);
        ImmutableSet.Builder excludedUsers = ImmutableSet.builder();
        for (String excludedGroupName : excludedGroupsFromCount) {
            MembershipQuery<String> query = QueryUtils.getMembersOfGroupQuery(excludedGroupName, 0, -1);
            List usersInExcludedGroup = directoryManager.searchDirectGroupRelationships(directoryLocator.getDirectoryId(), query);
            excludedUsers.addAll((Iterable)usersInExcludedGroup);
        }
        return excludedUsers.build();
    }

    private static Map<ReadOnlyApplicationLink, AccessLevel> calculateAccessLevel(final Option<String> mayBeUsername, final Set<String> groups, Map<ReadOnlyApplicationLink, ConfigurationEntity> appConfigs) {
        return Maps.transformValues(appConfigs, (Function)new Function<ConfigurationEntity, AccessLevel>(){

            public AccessLevel apply(ConfigurationEntity configurationEntity) {
                return UserProvisioningServiceImpl.calculateAccessLevelForApplication(mayBeUsername, groups, configurationEntity);
            }
        });
    }

    private static AccessLevel calculateAccessLevelForApplication(Option<String> mayBeUsername, Set<String> groupNames, ConfigurationEntity configurationEntity) {
        HashSet accessLevelsForUser = Sets.newHashSet();
        for (AccessLevel accessLevel : AccessLevel.values()) {
            if (!UserProvisioningServiceImpl.userHasAccessLevel(mayBeUsername, accessLevel, groupNames, configurationEntity)) continue;
            accessLevelsForUser.add(accessLevel);
        }
        return UserProvisioningServiceImpl.canUserLogin(accessLevelsForUser, configurationEntity) ? AccessLevel.findHighest(accessLevelsForUser) : AccessLevel.NONE;
    }

    private static boolean userHasAccessLevel(Option<String> mayBeUsername, AccessLevel accessLevel, Set<String> groups, ConfigurationEntity configurationEntity) {
        PermissionEntity permissionEntity = configurationEntity.getPermissions().get((Object)accessLevel);
        if (permissionEntity != null) {
            Set<String> groupsWithPermission = permissionEntity.getGroups().keySet();
            boolean userBelongsToGroupsWithPermission = !Sets.intersection(groupsWithPermission, groups).isEmpty();
            boolean userHasDirectPermission = !mayBeUsername.isEmpty() && permissionEntity.getUsers().contains(mayBeUsername.get());
            return userBelongsToGroupsWithPermission || userHasDirectPermission;
        }
        return false;
    }

    private static boolean canUserLogin(Set<AccessLevel> accessLevelsForUser, ConfigurationEntity configurationEntity) {
        return !Sets.intersection(configurationEntity.getCanLogin(), accessLevelsForUser).isEmpty();
    }

    private Set<String> getGroupsForUser(String username) throws DirectoryNotFoundException, OperationFailedException {
        return ImmutableSet.copyOf((Collection)this.directoryManager.searchNestedGroupRelationships(this.directoryLocator.getDirectoryId(), QueryUtils.getMembershipQuery(username)));
    }

    private Map<ReadOnlyApplicationLink, AccessLevel> calculateTargetUseAccessLevel(Map<ReadOnlyApplicationLink, ConfigurationEntity> appConfigs, final Map<ReadOnlyApplicationLink, AccessLevel> originalAccessLevels, Map<ReadOnlyApplicationLink, Boolean> targetUseAccessLevels) {
        return ImmutableMapUtils.transform(Maps.filterKeys(targetUseAccessLevels, (Predicate)Predicates.in(appConfigs.keySet())), new Function<Map.Entry<ReadOnlyApplicationLink, Boolean>, Map.Entry<ReadOnlyApplicationLink, AccessLevel>>(){

            public Map.Entry<ReadOnlyApplicationLink, AccessLevel> apply(Map.Entry<ReadOnlyApplicationLink, Boolean> input) {
                ReadOnlyApplicationLink applicationLink = input.getKey();
                AccessLevel originalAccessLevel = (AccessLevel)((Object)originalAccessLevels.get(applicationLink));
                Preconditions.checkState((originalAccessLevel != null ? 1 : 0) != 0);
                AccessLevel targetAccessLevel = input.getValue().booleanValue() ? (originalAccessLevel == AccessLevel.NONE ? AccessLevel.USE : originalAccessLevel) : AccessLevel.NONE;
                return Maps.immutableEntry((Object)applicationLink, (Object)((Object)targetAccessLevel));
            }
        });
    }

    private Either<ConflictingConfiguration, Set<String>> updateAccessLevel(Map<ReadOnlyApplicationLink, ConfigurationEntity> appConfigs, String username, Set<String> groups, Map<ReadOnlyApplicationLink, AccessLevel> originalAccessLevels, Map<ReadOnlyApplicationLink, AccessLevel> targetAccessLevels, boolean bypassValidation) throws ReadOnlyGroupException, DirectoryNotFoundException, GroupNotFoundException, UserNotFoundException, DirectoryPermissionException, OperationFailedException, CredentialsRequiredException, ResponseException {
        Map<ReadOnlyApplicationLink, AccessLevel> accessLevelAfterApplyGroupsDelta;
        Map<ReadOnlyApplicationLink, Delta<AccessLevel>> appsDelta = this.getApplicationLinkDelta(appConfigs, originalAccessLevels, targetAccessLevels);
        Delta<Set<String>> groupsDelta = this.calculateGroupsDelta(groups, appConfigs, appsDelta);
        ImmutableSet remainingGroups = ImmutableSet.builder().addAll((Iterable)Sets.difference(groups, (Set)((Set)groupsDelta.toRemove))).addAll((Iterable)groupsDelta.toAdd).build();
        Map<ReadOnlyApplicationLink, AccessLevel> map = accessLevelAfterApplyGroupsDelta = bypassValidation ? targetAccessLevels : UserProvisioningServiceImpl.calculateAccessLevel(Option.<String>none(), (Set<String>)remainingGroups, appConfigs);
        if (accessLevelAfterApplyGroupsDelta.equals(targetAccessLevels)) {
            this.updateGroupsForUser(username, groupsDelta);
            this.revokeIndividualAccess(username, appsDelta, appConfigs);
            return Either.right(remainingGroups);
        }
        return Either.left(new ConflictingConfiguration(targetAccessLevels, accessLevelAfterApplyGroupsDelta));
    }

    private void updateGroupsForUser(String username, Delta<Set<String>> groupsDelta) throws UserModificationNotAllowedException, SysadminGroupModificationNotAllowedException, DirectoryNotFoundException, OperationFailedException, UserNotFoundException, ReadOnlyGroupException, GroupNotFoundException, DirectoryPermissionException {
        try {
            this.preUpdateCheck(username, groupsDelta);
            for (String group : (Set)groupsDelta.toRemove) {
                this.directoryManager.removeUserFromGroup(this.directoryLocator.getDirectoryId(), username, group);
            }
            for (String group : (Set)groupsDelta.toAdd) {
                this.directoryManager.addUserToGroup(this.directoryLocator.getDirectoryId(), username, group);
            }
        }
        catch (MembershipAlreadyExistsException e) {
        }
        catch (MembershipNotFoundException membershipNotFoundException) {
            // empty catch block
        }
    }

    private void preUpdateCheck(String username, Delta<Set<String>> groupsDelta) throws SysadminGroupModificationNotAllowedException, DirectoryNotFoundException, OperationFailedException, UserModificationNotAllowedException {
        Option<Message> userValidationResults;
        if (this.userAndGroupCheckService.isCurrentUser(username)) {
            for (String groupName : (Set)groupsDelta.toRemove) {
                Option<ValidationResults> validationResults = this.userAndGroupCheckService.willCurrentUserBeDemotedByLeavingGroup(groupName);
                if (!validationResults.isDefined()) continue;
                throw new SysadminGroupModificationNotAllowedException((ValidationResults)validationResults.get());
            }
        }
        if ((userValidationResults = this.userAndGroupCheckService.canCurrentUserModifyUserAccess(username)).isDefined()) {
            throw new UserModificationNotAllowedException((Message)userValidationResults.get());
        }
        ImmutableList forbiddenGroupNames = ImmutableList.copyOf((Iterable)com.google.common.collect.Iterables.filter((Iterable)ImmutableSet.builder().addAll((Iterable)groupsDelta.toAdd).addAll((Iterable)groupsDelta.toRemove).build(), (Predicate)Predicates.not(UserAndGroupCheckServiceFunctions.canCurrentUserModifyGroup(this.userAndGroupCheckService))));
        if (!forbiddenGroupNames.isEmpty()) {
            throw new SysadminGroupModificationNotAllowedException((List<String>)forbiddenGroupNames);
        }
    }

    private Map<ReadOnlyApplicationLink, Delta<AccessLevel>> getApplicationLinkDelta(Map<ReadOnlyApplicationLink, ConfigurationEntity> appConfigs, Map<ReadOnlyApplicationLink, AccessLevel> originalAccessLevels, Map<ReadOnlyApplicationLink, AccessLevel> targetAccessLevels) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ReadOnlyApplicationLink applicationLink : appConfigs.keySet()) {
            AccessLevel oldLevel = originalAccessLevels.get(applicationLink);
            AccessLevel targetLevel = targetAccessLevels.get(applicationLink);
            if (oldLevel == null || targetLevel == null || oldLevel == targetLevel) continue;
            builder.put((Object)applicationLink, new Delta<AccessLevel>(oldLevel, targetLevel));
        }
        return builder.build();
    }

    private Delta<Set<String>> calculateGroupsDelta(Set<String> existingGroups, Map<ReadOnlyApplicationLink, ConfigurationEntity> appConfigs, Map<ReadOnlyApplicationLink, Delta<AccessLevel>> accessLevelDelta) {
        HashSet groupsMustNotBePresent = Sets.newHashSet();
        HashSet groupsShouldBePresent = Sets.newHashSet();
        for (Map.Entry<ReadOnlyApplicationLink, Delta<AccessLevel>> entry : accessLevelDelta.entrySet()) {
            ReadOnlyApplicationLink applicationLink = entry.getKey();
            Delta<AccessLevel> delta = entry.getValue();
            ConfigurationEntity configurationEntity = appConfigs.get(applicationLink);
            if (delta.toAdd == AccessLevel.NONE) {
                groupsMustNotBePresent.addAll(this.getAllLoginGroups(configurationEntity));
                continue;
            }
            if (delta.toRemove == AccessLevel.NONE) {
                Set<String> defaultLoginGroups = UserProvisioningServiceImpl.getDefaultUsersGroups(configurationEntity);
                groupsShouldBePresent.addAll(Sets.difference(defaultLoginGroups, (Set)groupsMustNotBePresent));
            }
            for (AccessLevel level : AccessLevel.rangeFromHighToLow((AccessLevel)((Object)delta.toRemove), (AccessLevel)((Object)delta.toAdd))) {
                Set<String> groupsForOldLevel = UserProvisioningServiceImpl.getGroupsForAccessLevel(configurationEntity, level);
                groupsMustNotBePresent.addAll(groupsForOldLevel);
            }
            Set<String> groupsForNewLevel = UserProvisioningServiceImpl.getGroupsForAccessLevel(configurationEntity, (AccessLevel)((Object)delta.toAdd));
            if (!Sets.intersection((Set)Sets.union((Set)Sets.difference(existingGroups, (Set)groupsMustNotBePresent), (Set)groupsShouldBePresent), groupsForNewLevel).isEmpty()) continue;
            Set<String> defaultGroupsForNewLevel = UserProvisioningServiceImpl.getDefaultGroupsForAccessLevels(configurationEntity, (AccessLevel)((Object)delta.toAdd));
            groupsShouldBePresent.addAll(defaultGroupsForNewLevel);
        }
        Sets.SetView groupsToLeave = Sets.intersection(existingGroups, (Set)groupsMustNotBePresent);
        Sets.SetView groupsToJoin = Sets.difference((Set)groupsShouldBePresent, existingGroups);
        return new Delta<Sets.SetView>(groupsToLeave, groupsToJoin);
    }

    private void revokeIndividualAccess(String username, Map<ReadOnlyApplicationLink, Delta<AccessLevel>> appsDelta, Map<ReadOnlyApplicationLink, ConfigurationEntity> appConfigs) throws CredentialsRequiredException, ResponseException {
        for (Map.Entry<ReadOnlyApplicationLink, Delta<AccessLevel>> entry : appsDelta.entrySet()) {
            ReadOnlyApplicationLink applicationLink = entry.getKey();
            Delta<AccessLevel> delta = entry.getValue();
            ConfigurationEntity configurationEntity = appConfigs.get(applicationLink);
            HashSet accessLevelsMustNotBePresent = Sets.newHashSet();
            if (delta.toAdd == AccessLevel.NONE) {
                accessLevelsMustNotBePresent.addAll(configurationEntity.getCanLogin());
            } else {
                accessLevelsMustNotBePresent.addAll(AccessLevel.rangeFromHighToLow((AccessLevel)((Object)delta.toRemove), (AccessLevel)((Object)delta.toAdd)));
            }
            for (AccessLevel accessLevel : accessLevelsMustNotBePresent) {
                Set<String> individuals = UserProvisioningServiceImpl.getIndividualsForAccessLevel(configurationEntity, accessLevel);
                if (!individuals.contains(username)) continue;
                applicationLink.createAuthenticatedRequestFactory().createRequest(Request.MethodType.DELETE, String.format(USER_PROVISIONING_REST_URL_PERMISSION_USER, accessLevel.name(), username)).execute();
            }
        }
    }

    private static Set<String> getAllGroupsExcludedFromLicenseCounting(ConfigurationEntity configurationEntity) {
        LicenseInformationEntity licenseInformation = configurationEntity.getLicenseInformation();
        Set<String> groupsForAccessLevels = UserProvisioningServiceImpl.getGroupsForAccessLevels(configurationEntity, licenseInformation.getAccessLevelsExcludedFromCount());
        return Sets.union(licenseInformation.getGroupsExcludedFromCount(), groupsForAccessLevels);
    }

    private static Set<String> getGroupsForAccessLevels(ConfigurationEntity configurationEntity, Set<AccessLevel> canLogin) {
        return ImmutableSet.copyOf(Iterables.flatMap(canLogin, UserProvisioningServiceImpl.accessLevelToGroupNamesMapper(configurationEntity)));
    }

    private static Set<String> getDefaultUsersGroups(ConfigurationEntity configurationEntity) {
        return UserProvisioningServiceImpl.getDefaultGroupsForAccessLevels(configurationEntity, AccessLevel.USE);
    }

    private static Set<String> getDefaultGroupsForAccessLevels(ConfigurationEntity configurationEntity, AccessLevel level) {
        return Maps.filterValues(configurationEntity.getPermissions().get((Object)level).getGroups(), (Predicate)new Predicate<GroupAttributesEntity>(){

            public boolean apply(GroupAttributesEntity groupAttributesEntity) {
                return groupAttributesEntity.isDefault();
            }
        }).keySet();
    }

    private static Set<String> getGroupsForAccessLevel(ConfigurationEntity configurationEntity, AccessLevel level) {
        return ImmutableSet.copyOf((Iterable)((Iterable)UserProvisioningServiceImpl.accessLevelToGroupNamesMapper(configurationEntity).apply((Object)level)));
    }

    private static Function<AccessLevel, Iterable<String>> accessLevelToGroupNamesMapper(final ConfigurationEntity configurationEntity) {
        return new Function<AccessLevel, Iterable<String>>(){

            public Iterable<String> apply(AccessLevel accessLevel) {
                PermissionEntity permissionEntity = configurationEntity.getPermissions().get((Object)accessLevel);
                return permissionEntity != null ? permissionEntity.getGroups().keySet() : ImmutableSet.of();
            }
        };
    }

    private static Set<String> getIndividualsForAccessLevels(ConfigurationEntity configurationEntity, Set<AccessLevel> levels) {
        return ImmutableSet.copyOf(Iterables.flatMap(levels, UserProvisioningServiceImpl.accessLevelToIndividualsMapper(configurationEntity)));
    }

    private static Set<String> getIndividualsForAccessLevel(ConfigurationEntity configurationEntity, AccessLevel level) {
        return ImmutableSet.copyOf((Iterable)((Iterable)UserProvisioningServiceImpl.accessLevelToIndividualsMapper(configurationEntity).apply((Object)level)));
    }

    private static Function<AccessLevel, Iterable<String>> accessLevelToIndividualsMapper(final ConfigurationEntity configurationEntity) {
        return new Function<AccessLevel, Iterable<String>>(){

            public Iterable<String> apply(AccessLevel accessLevel) {
                PermissionEntity permissionEntity = configurationEntity.getPermissions().get((Object)accessLevel);
                return permissionEntity != null ? permissionEntity.getUsers() : ImmutableSet.of();
            }
        };
    }

    private Either<LicenseExceeded, GrantAppAccessResult> grantApplicationAccess(Collection<String> usernames, boolean bypassAccessElevationCheck, ConfigurationEntity configurationEntity) throws DirectoryNotFoundException, OperationFailedException {
        ImmutableSet allUsers = ImmutableSet.copyOf(usernames);
        Supplier<Set<String>> findUsersGrantedAccessToApplicationSupplier = this.findUsersGrantedAccessToApplicationSupplier(configurationEntity);
        Sets.SetView usersToGrant = Sets.difference((Set)allUsers, (Set)((Set)findUsersGrantedAccessToApplicationSupplier.get()));
        Either<LicenseExceeded, Function<Set<String>, GrantAppAccessResult>> exceededOrFunction = this.reserveApplicationAccessSeats(usersToGrant.size(), bypassAccessElevationCheck, configurationEntity, findUsersGrantedAccessToApplicationSupplier);
        return exceededOrFunction.right().map(new Function<Function<Set<String>, GrantAppAccessResult>, GrantAppAccessResult>((Set)allUsers){
            final /* synthetic */ Set val$allUsers;
            {
                this.val$allUsers = set;
            }

            public GrantAppAccessResult apply(Function<Set<String>, GrantAppAccessResult> input) {
                return (GrantAppAccessResult)input.apply((Object)this.val$allUsers);
            }
        });
    }

    private Either<LicenseExceeded, Function<Set<String>, GrantAppAccessResult>> reserveApplicationAccessSeats(final int needed, boolean bypassAccessElevationCheck, final ConfigurationEntity configurationEntity, final Supplier<Set<String>> findUsersGrantedAccessToApplicationSupplier) throws SysadminGroupModificationNotAllowedException, DirectoryNotFoundException, OperationFailedException {
        Preconditions.checkArgument((needed >= 0 ? 1 : 0) != 0);
        Option<Integer> availableSeatsForApplication = UserProvisioningServiceImpl.calculateAvailableSeats(configurationEntity, findUsersGrantedAccessToApplicationSupplier, this.directoryManager, this.directoryLocator);
        if (availableSeatsForApplication.isEmpty() || (Integer)availableSeatsForApplication.get() >= needed) {
            ImmutableList forbiddenGroupNames;
            if (!bypassAccessElevationCheck && !(forbiddenGroupNames = ImmutableList.copyOf((Iterable)com.google.common.collect.Iterables.filter(UserProvisioningServiceImpl.getDefaultUsersGroups(configurationEntity), (Predicate)Predicates.not(UserAndGroupCheckServiceFunctions.canCurrentUserModifyGroup(this.userAndGroupCheckService))))).isEmpty()) {
                throw new SysadminGroupModificationNotAllowedException((List<String>)forbiddenGroupNames);
            }
            return Either.right(new Function<Set<String>, GrantAppAccessResult>(){

                public GrantAppAccessResult apply(Set<String> allUsers) {
                    HashSet addedUsers = Sets.newHashSet();
                    HashSet existingUsers = Sets.newHashSet();
                    Sets.SetView usersToGrant = Sets.difference(allUsers, (Set)((Set)findUsersGrantedAccessToApplicationSupplier.get()));
                    Set requestors = Sets.filter((Set)usersToGrant, ServiceDeskValidationFunctions.isServiceDeskRequestor(UserProvisioningServiceImpl.this.directoryLocator, UserProvisioningServiceImpl.this.directoryManager));
                    if (!requestors.isEmpty()) {
                        throw new ApplicationAccessChangeNotAllowedException(requestors);
                    }
                    Preconditions.checkArgument((usersToGrant.size() <= needed ? 1 : 0) != 0);
                    if (!usersToGrant.isEmpty()) {
                        for (String group : UserProvisioningServiceImpl.getDefaultUsersGroups(configurationEntity)) {
                            try {
                                BulkAddResult result = UserProvisioningServiceImpl.this.directoryManager.addAllUsersToGroup(UserProvisioningServiceImpl.this.directoryLocator.getDirectoryId(), (Collection)usersToGrant, group);
                                addedUsers.addAll(Sets.difference((Set)usersToGrant, (Set)ImmutableSet.copyOf((Collection)result.getFailedEntities())));
                                existingUsers.addAll(result.getExistingEntities());
                            }
                            catch (GroupNotFoundException e) {
                                log.warn("Trying to add use permissions for {}, and group {} has confluence use permissions but does not exist.", (Object)usersToGrant, (Object)group);
                            }
                            catch (RuntimeException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                log.error("", (Throwable)e);
                            }
                        }
                    }
                    existingUsers.addAll(Sets.intersection(allUsers, (Set)((Set)findUsersGrantedAccessToApplicationSupplier.get())));
                    Sets.SetView successes = Sets.union((Set)addedUsers, (Set)existingUsers);
                    Sets.SetView failures = Sets.difference(allUsers, (Set)successes);
                    return new GrantAppAccessResult((Set<String>)successes, (Set<String>)failures);
                }
            });
        }
        return Either.left(new LicenseExceeded(needed, (Integer)availableSeatsForApplication.get()));
    }

    public SortedSet<String> findUsernamesGrantedAccessToApplication(ConfigurationEntity configurationEntity) throws DirectoryNotFoundException, OperationFailedException {
        ImmutableSortedSet.Builder userNamesBuilder = ImmutableSortedSet.naturalOrder();
        for (String groupName : this.getAllLoginGroups(configurationEntity)) {
            MembershipQuery<User> query = QueryUtils.getMembersOfGroupQueryAsUser(groupName, 0, -1);
            for (User user : this.directoryManager.searchDirectGroupRelationships(this.directoryLocator.getDirectoryId(), query)) {
                if (!user.isActive()) continue;
                userNamesBuilder.add((Object)user.getName());
            }
        }
        Set<AccessLevel> canLoginAccessLevels = configurationEntity.getCanLogin();
        for (String username : UserProvisioningServiceImpl.getIndividualsForAccessLevels(configurationEntity, canLoginAccessLevels)) {
            try {
                if (!this.directoryManager.findUserByName(this.directoryLocator.getDirectoryId(), username).isActive()) continue;
                userNamesBuilder.add((Object)username);
            }
            catch (UserNotFoundException e) {
                log.warn("Whilst trying to calculate licence useage, User " + username + " does not exist");
            }
        }
        return userNamesBuilder.build();
    }

    public SortedSet<User> findUsersGrantedAccessToApplication(ConfigurationEntity configurationEntity) throws DirectoryNotFoundException, OperationFailedException {
        ImmutableSortedSet.Builder userBuilder = ImmutableSortedSet.naturalOrder();
        for (String groupName : this.getAllLoginGroups(configurationEntity)) {
            MembershipQuery<User> query = QueryUtils.getMembersOfGroupQueryAsUser(groupName, 0, -1);
            userBuilder.addAll((Iterable)this.directoryManager.searchDirectGroupRelationships(this.directoryLocator.getDirectoryId(), query));
        }
        Set<AccessLevel> canLoginAccessLevels = configurationEntity.getCanLogin();
        for (String username : UserProvisioningServiceImpl.getIndividualsForAccessLevels(configurationEntity, canLoginAccessLevels)) {
            try {
                userBuilder.add((Object)this.directoryManager.findUserByName(this.directoryLocator.getDirectoryId(), username));
            }
            catch (UserNotFoundException e) {
                log.warn("User \"" + username + "\" has permissions to an application but the user does not actually exist.", (Throwable)e);
            }
        }
        return userBuilder.build();
    }

    private Supplier<Set<String>> findUsersGrantedAccessToApplicationSupplier(final ConfigurationEntity configurationEntity) {
        return Suppliers.memoize((Supplier)new Supplier<Set<String>>(){

            public Set<String> get() {
                try {
                    return UserProvisioningServiceImpl.this.findUsernamesGrantedAccessToApplication(configurationEntity);
                }
                catch (DirectoryNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (OperationFailedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static class Delta<T> {
        public final T toRemove;
        public final T toAdd;

        public Delta(T toRemove, T toAdd) {
            this.toRemove = toRemove;
            this.toAdd = toAdd;
        }
    }
}

