/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.plugin.usermanagement.service.ReadOnlyApplicationLinkWithConfig;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ApplicationAccessError;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.ConfigurationEntity;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;

public class UserProvisioningServiceFunctions {
    private final UserProvisioningService userProvisioningService;

    public static Function<ReadOnlyApplicationLinkWithConfig, Option<Integer>> calculateAvailableSeatsForApplication(UserProvisioningService userProvisioningService) {
        return new UserProvisioningServiceFunctions(userProvisioningService).calculateAvailableSeatsForApplication();
    }

    public UserProvisioningServiceFunctions(UserProvisioningService userProvisioningService) {
        this.userProvisioningService = userProvisioningService;
    }

    public Function<ReadOnlyApplicationLinkWithConfig, Option<Integer>> calculateAvailableSeatsForApplication() {
        return new Function<ReadOnlyApplicationLinkWithConfig, Option<Integer>>(){

            public Option<Integer> apply(ReadOnlyApplicationLinkWithConfig input) {
                try {
                    Either<ApplicationAccessError, ConfigurationEntity> config = input.getConfig();
                    if (config.isLeft()) {
                        return Option.some(0);
                    }
                    return UserProvisioningServiceFunctions.this.userProvisioningService.getAvailableSeatsForApplication((ConfigurationEntity)config.right().get());
                }
                catch (DirectoryNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (OperationFailedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

