/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.permission.AnonymousUserPermissionException;
import com.atlassian.crowd.manager.permission.DirectoryGroupImpl;
import com.atlassian.crowd.manager.permission.PermittedGroup;
import com.atlassian.crowd.manager.permission.UserPermissionAdminService;
import com.atlassian.crowd.manager.permission.UserPermissionException;
import com.atlassian.crowd.manager.permission.UserPermissionService;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.permission.UserPermission;
import com.atlassian.crowd.plugin.rest.entity.MultiValuedAttributeEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.LozengeEntity;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupCheckService;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ValidationResults;
import com.atlassian.crowd.plugin.usermanagement.util.DefaultMessage;
import com.atlassian.crowd.plugin.usermanagement.util.ServiceDeskValidationFunctions;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;

public class UserAndGroupCheckServiceImpl
implements UserAndGroupCheckService {
    @VisibleForTesting
    static final int VERY_BEGINNING = 0;
    @VisibleForTesting
    static final int MAX_LIMIT = 0;
    private final DirectoryLocator directoryLocator;
    private final DirectoryManager directoryManager;
    private final UserPermissionAdminService userPermissionAdminService;
    private final UserManager userManager;
    private final UserPermissionService userPermissionService;
    protected final I18nResolver i18nResolver;
    Predicate<MultiValuedAttributeEntity> isServiceDeskAttribute = new Predicate<MultiValuedAttributeEntity>(){

        public boolean apply(@Nullable MultiValuedAttributeEntity input) {
            return input.getName().equals("synch.servicedesk.requestor");
        }
    };

    UserAndGroupCheckServiceImpl(DirectoryLocator directoryLocator, DirectoryManager directoryManager, UserPermissionAdminService userPermissionAdminService, UserManager userManager, UserPermissionService userPermissionService, I18nResolver i18nResolver) {
        this.directoryLocator = directoryLocator;
        this.directoryManager = directoryManager;
        this.userPermissionAdminService = userPermissionAdminService;
        this.userManager = userManager;
        this.userPermissionService = userPermissionService;
        this.i18nResolver = i18nResolver;
    }

    @VisibleForTesting
    boolean isCurrentUserSysadmin() {
        Option<String> maybeRemoteUsername = this.getCurrentUser();
        return maybeRemoteUsername.isDefined() && this.isUserSysadmin((String)maybeRemoteUsername.get());
    }

    @VisibleForTesting
    boolean isUserSysadmin(String username) {
        return this.userPermissionService.hasPermission(username, UserPermission.SYS_ADMIN);
    }

    @VisibleForTesting
    boolean isUserAddonSysadmin(String username) {
        try {
            return this.directoryManager.isUserNestedGroupMember(this.directoryLocator.getDirectoryId(), username, "atlassian-addons");
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (OperationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    boolean isUserServiceDeskRequestor(String username) {
        return ServiceDeskValidationFunctions.isServiceDeskRequestor(this.directoryLocator, this.directoryManager).apply((Object)username);
    }

    @VisibleForTesting
    boolean isSysadminGroup(String groupName) {
        try {
            ImmutableSet groupsToCheck = ImmutableSet.builder().addAll((Iterable)this.directoryManager.searchNestedGroupRelationships(this.directoryLocator.getDirectoryId(), UserAndGroupCheckServiceImpl.getParentGroupsQuery(groupName))).add((Object)groupName).build();
            Set<String> groupsWithSysadmin = this.findGroupNamesWithPermission(UserPermission.SYS_ADMIN);
            return !Sets.intersection((Set)groupsToCheck, groupsWithSysadmin).isEmpty();
        }
        catch (UserPermissionException e) {
            return true;
        }
        catch (AnonymousUserPermissionException e) {
            return true;
        }
        catch (OperationFailedException e) {
            throw new RuntimeException(e);
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Option<Message> canCurrentUserModifyUserAccess(String username) {
        if (!this.isCurrentUserSysadmin() && this.isUserSysadmin(username)) {
            return Option.some(new DefaultMessage("usermanagement.users.change.error.not.allowed", new Serializable[]{username}));
        }
        if (this.isUserServiceDeskRequestor(username)) {
            return Option.some(new DefaultMessage("usermanagement.users.change.error.not.allowed.servicedesk", new Serializable[]{username}));
        }
        return Option.none();
    }

    @Override
    public Option<LozengeEntity> getUserLozenge(UserEntity user) {
        if (!user.isActive().booleanValue()) {
            return Option.some(new LozengeEntity(this.i18nResolver.getText("usermanagement.users.lozenge.text.deactive"), this.i18nResolver.getText("usermanagement.users.lozenge.description.deactive")));
        }
        if (this.isUserAddonSysadmin(user.getName())) {
            return Option.some(new LozengeEntity(this.i18nResolver.getText("usermanagement.users.lozenge.text.addon_sysadmin"), this.i18nResolver.getText("usermanagement.users.lozenge.description.addon_sysadmin")));
        }
        if (this.isUserSysadmin(user.getName())) {
            return Option.some(new LozengeEntity(this.i18nResolver.getText("usermanagement.users.lozenge.text.sysadmin"), this.i18nResolver.getText("usermanagement.users.lozenge.description.sysadmin")));
        }
        if (com.google.common.collect.Iterables.any((Iterable)user.getAttributes(), this.isServiceDeskAttribute)) {
            return Option.some(new LozengeEntity(this.i18nResolver.getText("usermanagement.users.lozenge.text.servicedesk"), this.i18nResolver.getText("usermanagement.users.lozenge.description.servicedesk")));
        }
        return Option.none();
    }

    @Override
    public Option<Message> canCurrentUserModifyUserData(String username) {
        if (!this.isCurrentUserSysadmin() && this.isUserSysadmin(username)) {
            return Option.some(new DefaultMessage("usermanagement.users.change.error.not.allowed", new Serializable[]{username}));
        }
        return Option.none();
    }

    @Override
    public Option<ValidationResults> canCurrentUserModifyGroup(String groupName) {
        if (!this.isCurrentUserSysadmin() && this.isSysadminGroup(groupName)) {
            return Option.some(ValidationResults.errorResult(new DefaultMessage("usermanagement.users.sysadmin.groups.change.error.not.allowed", new Serializable[]{Integer.valueOf(1), groupName})));
        }
        return Option.none();
    }

    @Override
    public boolean isCurrentUser(String username) {
        Option<String> maybeUsername = this.getCurrentUser();
        return maybeUsername.isDefined() && IdentifierUtils.equalsInLowerCase((String)((String)maybeUsername.get()), (String)username);
    }

    @Override
    public Option<ValidationResults> willCurrentUserBeDemotedByLeavingGroup(String groupName) {
        if (this.isCurrentUserSysadmin() && !this.hasAdminPermissionOutsideOfGroup(UserPermission.SYS_ADMIN, groupName)) {
            return Option.some(ValidationResults.errorResult(new DefaultMessage("usermanagement.users.groups.delete.remove.sysadmin.access.rights", new Serializable[0])));
        }
        if (!this.isCurrentUserSysadmin() && !this.hasAdminPermissionOutsideOfGroup(UserPermission.ADMIN, groupName)) {
            return Option.some(ValidationResults.errorResult(new DefaultMessage("usermanagement.users.groups.delete.remove.admin.access.rights", new Serializable[0])));
        }
        return Option.none();
    }

    private boolean hasAdminPermissionOutsideOfGroup(UserPermission userPermission, String groupName) {
        Option<String> maybeRemoteUsername = this.getCurrentUser();
        if (maybeRemoteUsername.isEmpty()) {
            return false;
        }
        Directory directory = this.directoryLocator.getDirectory();
        return this.userPermissionService.hasPermissionOutsideOfGroups((String)maybeRemoteUsername.get(), userPermission, Collections.singleton(new DirectoryGroupImpl(directory.getId(), directory.getName(), groupName)));
    }

    private Option<String> getCurrentUser() {
        return Option.option(this.userManager.getRemoteUsername());
    }

    private static MembershipQuery<String> getParentGroupsQuery(String groupName) {
        return QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).parentsOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(groupName).returningAtMost(-1);
    }

    private Set<String> findGroupNamesWithPermission(UserPermission userPermission) throws UserPermissionException, AnonymousUserPermissionException {
        return ImmutableSet.copyOf(Iterables.collect(this.userPermissionAdminService.findGroupsWithPermission(0, 0).getResults(), new NameOfGroupWithPermissionPartialFunction(userPermission)));
    }

    private static class NameOfGroupWithPermissionPartialFunction
    implements Function<PermittedGroup, Option<String>> {
        private final UserPermission checkPermission;

        private NameOfGroupWithPermissionPartialFunction(UserPermission checkPermission) {
            this.checkPermission = (UserPermission)Preconditions.checkNotNull((Object)checkPermission);
        }

        public Option<String> apply(PermittedGroup permittedGroup) {
            return this.checkPermission.equals((Object)permittedGroup.getPermission()) ? Option.some(permittedGroup.getGroupName()) : Option.none(String.class);
        }
    }
}

