/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationInformation;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.DirectoryCurrentlySynchronisingException;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.NestedGroupsNotSupportedException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.runtime.CrowdRuntimeException;
import com.atlassian.crowd.manager.directory.BulkAddResult;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.BoundedCount;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class FilteringDirectoryManager
implements DirectoryManager {
    private final Predicate<String> ADDON_USERNAME = new Predicate<String>(){

        public boolean apply(@Nonnull String username) {
            try {
                return FilteringDirectoryManager.this.directoryManager.isUserNestedGroupMember(FilteringDirectoryManager.this.directoryLocator.getDirectoryId(), username, "atlassian-addons");
            }
            catch (DirectoryNotFoundException e) {
                throw new CrowdRuntimeException((Throwable)e);
            }
            catch (OperationFailedException e) {
                throw new CrowdRuntimeException((Throwable)e);
            }
        }
    };
    private final Predicate<String> SYSADMIN_USERNAME = new Predicate<String>(){

        public boolean apply(@Nonnull String username) {
            return FilteringDirectoryManager.this.userManager.isSystemAdmin(username);
        }
    };
    private final Predicate<User> ADDON_USER = new Predicate<User>(){

        public boolean apply(@Nonnull User user) {
            return FilteringDirectoryManager.this.ADDON_USERNAME.apply((Object)user.getName());
        }
    };
    private final Predicate<User> SYSADMIN_USER = new Predicate<User>(){

        public boolean apply(@Nonnull User user) {
            return FilteringDirectoryManager.this.SYSADMIN_USERNAME.apply((Object)user.getName());
        }
    };
    private final DirectoryManager directoryManager;
    private final DirectoryLocator directoryLocator;
    private final UserManager userManager;

    public FilteringDirectoryManager(@Nonnull DirectoryManager directoryManagerDelegate, @Nonnull DirectoryLocator directoryLocator, @Nonnull UserManager userManager) {
        this.directoryManager = (DirectoryManager)Preconditions.checkNotNull((Object)directoryManagerDelegate);
        this.directoryLocator = (DirectoryLocator)Preconditions.checkNotNull((Object)directoryLocator);
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
    }

    public <T> List<T> searchUsers(long directoryId, EntityQuery<T> query) throws DirectoryNotFoundException, OperationFailedException {
        List searchList = this.directoryManager.searchUsers(directoryId, query);
        return this.filterResults(searchList, query.getEntityDescriptor().getEntityType(), query.getReturnType());
    }

    public <T> List<T> searchDirectGroupRelationships(long directoryId, MembershipQuery<T> query) throws DirectoryNotFoundException, OperationFailedException {
        List searchList = this.directoryManager.searchDirectGroupRelationships(directoryId, query);
        return this.filterResults(searchList, query.getEntityToReturn().getEntityType(), query.getReturnType());
    }

    @VisibleForTesting
    <T> List<T> filterResults(@Nonnull List<T> searchList, Entity searchEntity, Class<T> returnType) {
        if (Entity.USER == searchEntity && this.isRemoteUserNonSysadmin()) {
            if (User.class.isAssignableFrom(returnType)) {
                return ImmutableList.copyOf((Iterable)Iterables.filter(searchList, (Predicate)Predicates.or(this.ADDON_USER, (Predicate)Predicates.not(this.SYSADMIN_USER))));
            }
            if (String.class == returnType) {
                return ImmutableList.copyOf((Iterable)Iterables.filter(searchList, (Predicate)Predicates.or(this.ADDON_USERNAME, (Predicate)Predicates.not(this.SYSADMIN_USERNAME))));
            }
            return searchList;
        }
        return searchList;
    }

    @VisibleForTesting
    boolean isRemoteUserNonSysadmin() {
        String remoteUser = this.userManager.getRemoteUsername();
        return remoteUser != null && !this.userManager.isSystemAdmin(remoteUser);
    }

    public Directory addDirectory(Directory directory) throws DirectoryInstantiationException {
        return this.directoryManager.addDirectory(directory);
    }

    public Directory findDirectoryById(long directoryID) throws DirectoryNotFoundException {
        return this.directoryManager.findDirectoryById(directoryID);
    }

    public List<Directory> findAllDirectories() {
        return this.directoryManager.findAllDirectories();
    }

    public List<Directory> searchDirectories(EntityQuery<Directory> query) {
        return this.directoryManager.searchDirectories(query);
    }

    public Directory findDirectoryByName(String name) throws DirectoryNotFoundException {
        return this.directoryManager.findDirectoryByName(name);
    }

    public Directory updateDirectory(Directory directory) throws DirectoryNotFoundException {
        return this.directoryManager.updateDirectory(directory);
    }

    public void removeDirectory(Directory directory) throws DirectoryNotFoundException, DirectoryCurrentlySynchronisingException {
        this.directoryManager.removeDirectory(directory);
    }

    public User authenticateUser(long directoryId, String username, PasswordCredential passwordCredential) throws OperationFailedException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException, DirectoryNotFoundException, UserNotFoundException {
        return this.directoryManager.authenticateUser(directoryId, username, passwordCredential);
    }

    public User findUserByName(long directoryId, String username) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        return this.directoryManager.findUserByName(directoryId, username);
    }

    public UserWithAttributes findUserWithAttributesByName(long directoryId, String username) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        return this.directoryManager.findUserWithAttributesByName(directoryId, username);
    }

    public User findUserByExternalId(long directoryId, String externalId) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        return this.directoryManager.findUserByExternalId(directoryId, externalId);
    }

    public UserWithAttributes findUserWithAttributesByExternalId(long directoryId, String externalId) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        return this.directoryManager.findUserWithAttributesByExternalId(directoryId, externalId);
    }

    public UserWithAttributes addUser(long directoryId, UserTemplateWithAttributes user, PasswordCredential credential) throws InvalidCredentialException, InvalidUserException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, UserAlreadyExistsException {
        return this.directoryManager.addUser(directoryId, user, credential);
    }

    public User addUser(long directoryId, UserTemplate user, PasswordCredential credential) throws InvalidCredentialException, InvalidUserException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, UserAlreadyExistsException {
        return this.directoryManager.addUser(directoryId, UserTemplateWithAttributes.toUserWithNoAttributes((User)user), credential);
    }

    public User updateUser(long directoryId, UserTemplate user) throws DirectoryNotFoundException, UserNotFoundException, DirectoryPermissionException, InvalidUserException, OperationFailedException {
        return this.directoryManager.updateUser(directoryId, user);
    }

    public User renameUser(long directoryId, String oldUsername, String newUsername) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException, DirectoryPermissionException, InvalidUserException, UserAlreadyExistsException {
        return this.directoryManager.renameUser(directoryId, oldUsername, newUsername);
    }

    public void storeUserAttributes(long directoryId, String username, Map<String, Set<String>> attributes) throws DirectoryPermissionException, DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        this.directoryManager.storeUserAttributes(directoryId, username, attributes);
    }

    public void removeUserAttributes(long directoryId, String username, String attributeName) throws DirectoryPermissionException, DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        this.directoryManager.removeUserAttributes(directoryId, username, attributeName);
    }

    public void updateUserCredential(long directoryId, String username, PasswordCredential credential) throws DirectoryPermissionException, InvalidCredentialException, DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        this.directoryManager.updateUserCredential(directoryId, username, credential);
    }

    public void removeUser(long directoryId, String username) throws DirectoryNotFoundException, UserNotFoundException, DirectoryPermissionException, OperationFailedException {
        this.directoryManager.removeUser(directoryId, username);
    }

    public Group findGroupByName(long directoryId, String groupName) throws GroupNotFoundException, DirectoryNotFoundException, OperationFailedException {
        return this.directoryManager.findGroupByName(directoryId, groupName);
    }

    public GroupWithAttributes findGroupWithAttributesByName(long directoryId, String groupName) throws GroupNotFoundException, DirectoryNotFoundException, OperationFailedException {
        return this.directoryManager.findGroupWithAttributesByName(directoryId, groupName);
    }

    public <T> List<T> searchGroups(long directoryId, EntityQuery<T> query) throws DirectoryNotFoundException, OperationFailedException {
        return this.directoryManager.searchGroups(directoryId, query);
    }

    public Group addGroup(long directoryId, GroupTemplate group) throws InvalidGroupException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException {
        return this.directoryManager.addGroup(directoryId, group);
    }

    public Group updateGroup(long directoryId, GroupTemplate group) throws GroupNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, InvalidGroupException, OperationFailedException, ReadOnlyGroupException {
        return this.directoryManager.updateGroup(directoryId, group);
    }

    public Group renameGroup(long directoryId, String oldGroupname, String newGroupname) throws GroupNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, InvalidGroupException, OperationFailedException {
        return this.directoryManager.renameGroup(directoryId, oldGroupname, newGroupname);
    }

    public void storeGroupAttributes(long directoryId, String groupName, Map<String, Set<String>> attributes) throws DirectoryPermissionException, GroupNotFoundException, DirectoryNotFoundException, OperationFailedException {
        this.directoryManager.storeGroupAttributes(directoryId, groupName, attributes);
    }

    public void removeGroupAttributes(long directoryId, String groupName, String attributeName) throws DirectoryPermissionException, GroupNotFoundException, DirectoryNotFoundException, OperationFailedException {
        this.directoryManager.removeGroupAttributes(directoryId, groupName, attributeName);
    }

    public void removeGroup(long directoryId, String groupName) throws GroupNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, OperationFailedException, ReadOnlyGroupException {
        this.directoryManager.removeGroup(directoryId, groupName);
    }

    public boolean isUserDirectGroupMember(long directoryId, String username, String groupName) throws DirectoryNotFoundException, OperationFailedException {
        return this.directoryManager.isUserDirectGroupMember(directoryId, username, groupName);
    }

    public boolean isGroupDirectGroupMember(long directoryId, String childGroup, String parentGroup) throws DirectoryNotFoundException, OperationFailedException {
        return this.directoryManager.isGroupDirectGroupMember(directoryId, childGroup, parentGroup);
    }

    public void addUserToGroup(long directoryId, String username, String groupName) throws DirectoryPermissionException, DirectoryNotFoundException, UserNotFoundException, GroupNotFoundException, OperationFailedException, ReadOnlyGroupException, MembershipAlreadyExistsException {
        this.directoryManager.addUserToGroup(directoryId, username, groupName);
    }

    public void addGroupToGroup(long directoryId, String childGroup, String parentGroup) throws DirectoryPermissionException, DirectoryNotFoundException, GroupNotFoundException, InvalidMembershipException, NestedGroupsNotSupportedException, OperationFailedException, ReadOnlyGroupException, MembershipAlreadyExistsException {
        this.directoryManager.addGroupToGroup(directoryId, childGroup, parentGroup);
    }

    public void removeUserFromGroup(long directoryId, String username, String groupName) throws DirectoryPermissionException, DirectoryNotFoundException, UserNotFoundException, GroupNotFoundException, MembershipNotFoundException, OperationFailedException, ReadOnlyGroupException {
        this.directoryManager.removeUserFromGroup(directoryId, username, groupName);
    }

    public void removeGroupFromGroup(long directoryId, String childGroup, String parentGroup) throws DirectoryPermissionException, GroupNotFoundException, DirectoryNotFoundException, InvalidMembershipException, MembershipNotFoundException, OperationFailedException, ReadOnlyGroupException {
        this.directoryManager.removeGroupFromGroup(directoryId, childGroup, parentGroup);
    }

    public boolean isUserNestedGroupMember(long directoryId, String username, String groupName) throws DirectoryNotFoundException, OperationFailedException {
        return this.directoryManager.isUserNestedGroupMember(directoryId, username, groupName);
    }

    public boolean isGroupNestedGroupMember(long directoryId, String childGroup, String parentGroup) throws DirectoryNotFoundException, OperationFailedException {
        return this.directoryManager.isGroupNestedGroupMember(directoryId, childGroup, parentGroup);
    }

    public BoundedCount countDirectMembersOfGroup(long directoryId, String groupName, int querySizeHint) throws DirectoryNotFoundException, OperationFailedException {
        return this.directoryManager.countDirectMembersOfGroup(directoryId, groupName, querySizeHint);
    }

    public <T> List<T> searchNestedGroupRelationships(long directoryId, MembershipQuery<T> query) throws DirectoryNotFoundException, OperationFailedException {
        return this.directoryManager.searchNestedGroupRelationships(directoryId, query);
    }

    public BulkAddResult<User> addAllUsers(long directoryId, Collection<UserTemplateWithCredentialAndAttributes> users, boolean overwrite) throws DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException {
        return this.directoryManager.addAllUsers(directoryId, users, overwrite);
    }

    public BulkAddResult<Group> addAllGroups(long directoryId, Collection<GroupTemplate> groups, boolean overwrite) throws DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, InvalidGroupException {
        return this.directoryManager.addAllGroups(directoryId, groups, overwrite);
    }

    public BulkAddResult<String> addAllUsersToGroup(long directoryID, Collection<String> userNames, String groupName) throws DirectoryPermissionException, DirectoryNotFoundException, GroupNotFoundException, OperationFailedException {
        return this.directoryManager.addAllUsersToGroup(directoryID, userNames, groupName);
    }

    public boolean supportsNestedGroups(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        return this.directoryManager.supportsNestedGroups(directoryId);
    }

    public boolean isSynchronisable(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        return this.directoryManager.isSynchronisable(directoryId);
    }

    public void synchroniseCache(long directoryId, SynchronisationMode mode) throws OperationFailedException, DirectoryNotFoundException {
        this.directoryManager.synchroniseCache(directoryId, mode);
    }

    public void synchroniseCache(long directoryId, SynchronisationMode mode, boolean runInBackground) throws OperationFailedException, DirectoryNotFoundException {
        this.directoryManager.synchroniseCache(directoryId, mode, runInBackground);
    }

    public boolean isSynchronising(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        return this.directoryManager.isSynchronising(directoryId);
    }

    public DirectorySynchronisationInformation getDirectorySynchronisationInformation(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        return this.directoryManager.getDirectorySynchronisationInformation(directoryId);
    }

    public boolean supportsExpireAllPasswords(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        return this.directoryManager.supportsExpireAllPasswords(directoryId);
    }

    public void expireAllPasswords(long directoryId) throws OperationFailedException, DirectoryNotFoundException {
        this.directoryManager.expireAllPasswords(directoryId);
    }
}

