/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.ConfigurationEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.LicenseInformationEntity;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;

public class ConfigurationEntityFunctions {
    private static final int UNLIMITED = -1;
    private static Function<ConfigurationEntity, Option<Integer>> TO_LICENSE_LIMIT = new Function<ConfigurationEntity, Option<Integer>>(){

        public Option<Integer> apply(ConfigurationEntity input) {
            LicenseInformationEntity licenseInformation = input.getLicenseInformation();
            int licenseLimit = licenseInformation.getLimit();
            if (licenseLimit != -1) {
                return Option.some(licenseLimit);
            }
            return Option.none(Integer.class);
        }
    };

    public static Function<ConfigurationEntity, Option<Integer>> toLicenseLimit() {
        return TO_LICENSE_LIMIT;
    }
}

