/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.service;

import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkProductService;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.host.HostEntity;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectReader;

public class ApplicationLinkProductServiceImpl
implements ApplicationLinkProductService {
    private static final String PRODUCTSTORAGEKEY = "products.config.data";
    private static final String PRODUCTLIST = "product.config.list";
    private ConcurrentHashMap<String, HostEntity> products = new ConcurrentHashMap();
    private PluginSettings pluginSettings;
    private ObjectMapper mapper = new ObjectMapper();
    private ObjectReader productReader = this.mapper.reader(HostEntity.class);
    private ObjectReader listReader = this.mapper.reader(ProductList.class);
    private ProductList productList;

    public ApplicationLinkProductServiceImpl(PluginSettingsFactory pluginSettingsFactory) throws IOException {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey(PRODUCTSTORAGEKEY);
        String productListJson = (String)this.pluginSettings.get(PRODUCTLIST);
        this.productList = productListJson != null ? (ProductList)this.listReader.readValue(productListJson) : new ProductList(new ArrayList());
    }

    @Override
    public boolean put(HostEntity entity) throws Exception {
        if (entity != null && entity.getDescription().getId() != null && !this.products.contains(entity.getDescription().getId())) {
            if (!this.productList.products.contains(entity.getDescription().getId())) {
                this.productList.products.add(entity.getDescription().getId());
                this.pluginSettings.put(PRODUCTLIST, (Object)this.mapper.writeValueAsString((Object)this.productList));
            }
            this.pluginSettings.put(entity.getDescription().getId(), (Object)this.mapper.writeValueAsString((Object)entity));
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(String hostID) {
        return this.pluginSettings.get(hostID) != null;
    }

    @Override
    public HostEntity get(String hostID) throws Exception {
        if (this.productList.products.contains(hostID)) {
            String productJson = (String)this.pluginSettings.get(hostID);
            if (productJson != null) {
                return (HostEntity)this.productReader.readValue((String)this.pluginSettings.get(hostID));
            }
            return null;
        }
        return null;
    }

    @Override
    public Set<String> getHostIDs() {
        return ImmutableSet.copyOf((Collection)this.productList.products);
    }

    @JsonAutoDetect
    public static class ProductList {
        private List<String> products;

        private ProductList(@JsonProperty(value="products") List<String> products) {
            this.products = products;
        }

        public List<String> getProducts() {
            return this.products;
        }
    }
}

