/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ApplicationEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ApplicationValidationResultEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ValidationResultsEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.resource.BaseResource;
import com.atlassian.crowd.plugin.usermanagement.rest.util.I18nFunctions;
import com.atlassian.crowd.plugin.usermanagement.rest.util.RestResources;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupService;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ValidationResults;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.ValidationMessageEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.ValidationResultEntity;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="validation")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ResourceFilters(value={AdminOnlyResourceFilter.class})
public class ValidationResource
extends BaseResource {
    private final UserAndGroupService userAndGroupService;
    private final I18nResolver i18nResolver;
    private final Function<ReadOnlyApplicationLink, ApplicationEntity> APPLICATION_ENTITY_TRANSFORMER = new Function<ReadOnlyApplicationLink, ApplicationEntity>(){

        public ApplicationEntity apply(ReadOnlyApplicationLink application) {
            return ApplicationEntity.fromApplicationLink(application, ValidationResource.this.i18nResolver);
        }
    };
    private final Function<Map.Entry<ReadOnlyApplicationLink, ValidationResultEntity>, ApplicationValidationResultEntity> ENTRY_TO_ENTITY = new Function<Map.Entry<ReadOnlyApplicationLink, ValidationResultEntity>, ApplicationValidationResultEntity>(){

        public ApplicationValidationResultEntity apply(Map.Entry<ReadOnlyApplicationLink, ValidationResultEntity> entry) {
            ReadOnlyApplicationLink applicationLink = entry.getKey();
            ValidationResultEntity validationResultEntity = entry.getValue();
            return new ApplicationValidationResultEntity((ApplicationEntity)ValidationResource.this.APPLICATION_ENTITY_TRANSFORMER.apply((Object)applicationLink), validationResultEntity.getWarnings(), validationResultEntity.getErrors());
        }
    };

    public ValidationResource(UserAndGroupService userAndGroupService, I18nResolver i18nResolver) {
        this.userAndGroupService = userAndGroupService;
        this.i18nResolver = i18nResolver;
    }

    @GET
    @Path(value="user/predelete")
    public Response userPreDelete(@QueryParam(value="username") String username) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        RestResources.checkParam("username", username);
        ValidationResults result = this.userAndGroupService.userPreDelete(username);
        return this.buildValidationResultResponse(result);
    }

    @GET
    @Path(value="group/predelete")
    public Response groupPreDelete(@QueryParam(value="groupname") String groupname) throws DirectoryNotFoundException, OperationFailedException, GroupNotFoundException {
        RestResources.checkParam("groupname", groupname);
        ValidationResults result = this.userAndGroupService.groupPreDelete(groupname);
        return this.buildValidationResultResponse(result);
    }

    private Response buildValidationResultResponse(ValidationResults result) {
        Function transformer = Functions.compose(ValidationMessageEntity.newValidationMessageEntityFunction(), I18nFunctions.translate(this.i18nResolver));
        Map<ReadOnlyApplicationLink, ValidationResultEntity> applicationValidationResults = result.getApplicationValidationResults();
        return ResponseFactory.ok(new ValidationResultsEntity(Collections.<ValidationMessageEntity>emptyList(), Lists.transform(result.getGenericErrors(), (Function)transformer), this.transformApplicationResults(applicationValidationResults))).build();
    }

    private Collection<ApplicationValidationResultEntity> transformApplicationResults(Map<ReadOnlyApplicationLink, ValidationResultEntity> applicationValidationResults) {
        return Collections2.transform(applicationValidationResults.entrySet(), this.ENTRY_TO_ENTITY);
    }
}

