/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.ObjectAlreadyExistsException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.manager.mail.MailSendException;
import com.atlassian.crowd.plugin.rest.entity.GroupEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntityList;
import com.atlassian.crowd.plugin.rest.entity.PasswordEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.crowd.plugin.usermanagement.feature.FeatureGuard;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.UserController;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.BulkAppAccessOperationResult;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.InvitationsRequestEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ListViewUser;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.UserFormEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.UsersApplicationsAccessList;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ApplicationAccessChangeNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ApplicationAccessErrorException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.EmailAlreadyExistsException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.GroupMembershipChangeNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.GroupsCausingLicenseException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.LicenseExceededException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.MailServerConfigurationException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.SysadminGroupModificationNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.UserCannotBeDeletedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.UserModificationNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.resource.BaseResource;
import com.atlassian.crowd.plugin.usermanagement.rest.util.RestResources;
import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkConfigService;
import com.atlassian.crowd.plugin.usermanagement.service.ConflictingConfiguration;
import com.atlassian.crowd.plugin.usermanagement.service.ReadOnlyApplicationLinkWithConfig;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupCheckService;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupService;
import com.atlassian.crowd.plugin.usermanagement.util.EmailFunctions;
import com.atlassian.crowd.plugin.usermanagement.util.GroupFunctions;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.fugue.Either;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.AddressException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="user")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ResourceFilters(value={AdminOnlyResourceFilter.class})
public class UsersResource
extends BaseResource {
    private final UserController userController;
    private final UserAndGroupService userAndGroupService;
    private final I18nResolver i18nResolver;
    private final ApplicationLinkConfigService applicationLinkConfigService;
    private final UserAndGroupCheckService userAndGroupCheckService;
    private final DarkFeatureManager darkFeatureManager;

    public UsersResource(UserController userController, UserAndGroupService userAndGroupService, I18nResolver i18nResolver, ApplicationLinkConfigService applicationLinkConfigService, UserAndGroupCheckService userAndGroupCheckService, DarkFeatureManager darkFeatureManager) {
        this.applicationLinkConfigService = applicationLinkConfigService;
        this.darkFeatureManager = darkFeatureManager;
        this.userController = (UserController)Preconditions.checkNotNull((Object)userController);
        this.userAndGroupService = userAndGroupService;
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
        this.userAndGroupCheckService = userAndGroupCheckService;
    }

    @GET
    public Response getUser(@QueryParam(value="username") String userName) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException, DirectoryPermissionException {
        RestResources.checkParam("username", userName);
        UserEntity user = this.userController.getUser(userName, this.getBaseUri());
        return ResponseFactory.ok(user).build();
    }

    @GET
    @Path(value="hasUsersOfType")
    public Response hasUserType(@QueryParam(value="userFilter") String userType) throws DirectoryNotFoundException, OperationFailedException, UserNotFoundException {
        Iterable<UserEntity> users = this.userController.findUsersByName("", 0, 1, this.getBaseUri(), Collections.singletonList(userType), null, Collections.<String>emptyList());
        return ResponseFactory.ok(!Iterables.isEmpty(users)).build();
    }

    @GET
    @Path(value="search")
    public Response searchUsers(@QueryParam(value="filter") String filter, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex, @DefaultValue(value="50") @QueryParam(value="max-results") int maxResults, @QueryParam(value="userFilters") List<String> userFilters, @QueryParam(value="activeFilter") List<Boolean> activeFilter, @QueryParam(value="n") List<String> newUserNamesToPrepend) throws DirectoryNotFoundException, OperationFailedException, UserNotFoundException {
        Iterable<UserEntity> userEntities = this.userController.findUsersByName(filter, startIndex, maxResults, this.getBaseUri(), userFilters, activeFilter, newUserNamesToPrepend);
        Iterable users = Iterables.transform(userEntities, ListViewUser.fromUserEntityPredicate(this.userAndGroupCheckService, this.i18nResolver));
        return ResponseFactory.ok(users).build();
    }

    @POST
    public Response addUser(UserFormEntity userEntity) throws InvalidCredentialException, DirectoryPermissionException, DirectoryNotFoundException, InvalidUserException, OperationFailedException, InvalidEmailAddressException, UserNotFoundException, ReadOnlyGroupException, GroupNotFoundException, IOException, MembershipAlreadyExistsException, ResponseException, LicenseExceededException, ApplicationAccessErrorException, MailServerConfigurationException, UserAlreadyExistsException, EmailAlreadyExistsException {
        HashMap errors = Maps.newHashMap();
        Preconditions.checkArgument((userEntity != null ? 1 : 0) != 0);
        this.checkUserDetailsFields(userEntity, errors);
        if (UsersResource.hasErrors(errors)) {
            return UsersResource.buildErrors(errors);
        }
        UserEntity createdUser = this.userController.addUser(userEntity, this.getBaseUri(), userEntity.getApplications());
        URI location = LinkUriHelper.buildUserUri(this.getBaseUri(), createdUser.getName());
        return ResponseFactory.created(location).entity((Object)createdUser).build();
    }

    @POST
    @Path(value="invite")
    public Response inviteUser(InvitationsRequestEntity request) throws MailSendException, MailServerConfigurationException, AddressException, DirectoryNotFoundException, OperationFailedException, UserNotFoundException, ObjectAlreadyExistsException, InvalidCredentialException, InvalidUserException, EmailAlreadyExistsException, LicenseExceededException, DirectoryPermissionException {
        return ResponseFactory.ok(this.userController.inviteUser(request.getEmailAddresses(), request.getApplications(), request.getExpiryDays(), request.getText(), this.getBaseUrl())).build();
    }

    @POST
    @Path(value="access")
    public Response grantApplicationAccess(UsersApplicationsAccessList usersApplicationsAccessList) throws DirectoryNotFoundException, OperationFailedException, ApplicationAccessChangeNotAllowedException {
        String group = usersApplicationsAccessList.getGroup();
        List<String> usernames = usersApplicationsAccessList.getUsernames();
        Iterable<ReadOnlyApplicationLinkWithConfig> applicationLinks = this.applicationLinkConfigService.fetchAllConfigsForApplicationIds(usersApplicationsAccessList.getApplicationLinks());
        BulkAppAccessOperationResult result = group != null ? this.userController.grantApplicationAccess(group, applicationLinks) : this.userController.grantApplicationAccess(usernames, applicationLinks);
        return ResponseFactory.ok(result).build();
    }

    @DELETE
    @Path(value="access")
    public Response revokeApplicationAccess(@QueryParam(value="username") String username, @QueryParam(value="appLinkId") String appLinkId) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException, GroupNotFoundException, ReadOnlyGroupException, DirectoryPermissionException, CredentialsRequiredException, ResponseException {
        Either<ConflictingConfiguration, UserEntity> result = this.userController.revokeApplicationAccess(username, this.getBaseUri(), appLinkId);
        if (result.isRight()) {
            return ResponseFactory.noContent().build();
        }
        return this.buildResponseForConflictingConfiguration((ConflictingConfiguration)result.left().get());
    }

    @PUT
    public Response updateUser(@QueryParam(value="username") String userName, UserFormEntity userFormEntity) throws UserNotFoundException, InvalidUserException, DirectoryNotFoundException, OperationFailedException, DirectoryPermissionException, UserModificationNotAllowedException, EmailAlreadyExistsException, UserAlreadyExistsException {
        HashMap errors = Maps.newHashMap();
        Preconditions.checkArgument((userName != null ? 1 : 0) != 0);
        Preconditions.checkArgument((userFormEntity != null ? 1 : 0) != 0);
        this.checkUserDetailsFields(userFormEntity, errors);
        if (UsersResource.hasErrors(errors)) {
            return UsersResource.buildErrors(errors);
        }
        if (!StringUtils.equals(userName, userFormEntity.getName())) {
            this.userController.renameUser(userName, userFormEntity);
        }
        UserEntity userEntity = this.userController.updateUser(userFormEntity, this.getBaseUri(), false);
        return ResponseFactory.status(Response.Status.OK).entity((Object)userEntity).build();
    }

    private Response buildResponseForConflictingConfiguration(ConflictingConfiguration malConfig) {
        return UsersResource.buildErrors(this.i18nResolver.getText("usermanagement.apps.change.fail.on.conflict.config"));
    }

    @DELETE
    public Response deleteUser(@QueryParam(value="username") String userName) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException, DirectoryPermissionException, UserCannotBeDeletedException {
        RestResources.checkParam("username", userName);
        this.userAndGroupService.deleteUser(userName);
        return ResponseFactory.noContent().build();
    }

    @PUT
    @Path(value="password")
    public Response updateUserPassword(@QueryParam(value="username") String userName, PasswordEntity passwordEntity) throws InvalidCredentialException, DirectoryNotFoundException, UserNotFoundException, OperationFailedException, DirectoryPermissionException, UserModificationNotAllowedException {
        RestResources.checkParam("username", userName);
        HashMap errors = Maps.newHashMap();
        this.checkPassword(passwordEntity, errors);
        if (UsersResource.hasErrors(errors)) {
            return UsersResource.buildErrors(errors);
        }
        this.userController.updateUserPassword(userName, passwordEntity.getValue());
        return ResponseFactory.noContent().build();
    }

    @GET
    @Path(value="group/direct")
    public Response getDirectGroups(@QueryParam(value="username") String userName, @QueryParam(value="groupname") String groupName, @QueryParam(value="n") List<String> newGroupNamesToPrepend, @DefaultValue(value="50") @QueryParam(value="max-results") int maxResults, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex) throws MembershipNotFoundException, DirectoryNotFoundException, OperationFailedException {
        RestResources.checkParam("username", userName);
        if (StringUtils.isEmpty(groupName)) {
            GroupEntityList directGroups = this.userController.getDirectGroups(userName, maxResults, startIndex, newGroupNamesToPrepend, this.getBaseUri());
            return ResponseFactory.ok(directGroups).build();
        }
        GroupEntity directGroup = this.userController.getDirectGroup(userName, groupName, this.getBaseUri());
        return ResponseFactory.ok(directGroup).build();
    }

    @POST
    @Path(value="group/direct")
    public Response addUserToGroup(@QueryParam(value="username") String userName, GroupEntityList groupList) throws UserNotFoundException, ApplicationPermissionException, OperationFailedException, ReadOnlyGroupException, GroupNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, SysadminGroupModificationNotAllowedException, ApplicationAccessErrorException, GroupsCausingLicenseException, UserModificationNotAllowedException, GroupMembershipChangeNotAllowedException {
        RestResources.checkParam("username", userName);
        Iterable groupNames = Iterables.transform((Iterable)groupList, GroupFunctions.groupEntityNameGetter());
        this.userAndGroupService.addUserToGroups(userName, (Set<String>)ImmutableSet.copyOf((Iterable)groupNames));
        return ResponseFactory.ok(groupList).build();
    }

    @DELETE
    @Path(value="group/direct")
    public Response removeUserFromGroup(@QueryParam(value="username") String userName, @QueryParam(value="groupname") String groupName) throws GroupNotFoundException, MembershipNotFoundException, UserNotFoundException, ApplicationPermissionException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException, ReadOnlyGroupException, SysadminGroupModificationNotAllowedException, UserModificationNotAllowedException {
        RestResources.checkParam("username", userName);
        this.userAndGroupService.removeUserFromGroup(userName, groupName);
        return ResponseFactory.noContent().build();
    }

    @DELETE
    @Path(value="AID")
    public Response dissociateAIDFromCrowdUser(@QueryParam(value="username") String userName) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException, DirectoryPermissionException {
        RestResources.checkParam("username", userName);
        this.userController.removeAIDFromUser(userName);
        return ResponseFactory.noContent().build();
    }

    @POST
    @Path(value="deactivate")
    @FeatureGuard(value="um.disable.user")
    public Response deactivateUser(@QueryParam(value="username") String username) throws UserNotFoundException, InvalidUserException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException, UserModificationNotAllowedException {
        this.userController.updateUserActive(username, this.getBaseUri(), false);
        return ResponseFactory.ok().build();
    }

    @POST
    @Path(value="activate")
    @FeatureGuard(value="um.disable.user")
    public Response activateUser(@QueryParam(value="username") String username) throws UserNotFoundException, InvalidUserException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException, UserModificationNotAllowedException {
        this.userController.updateUserActive(username, this.getBaseUri(), true);
        return ResponseFactory.ok().build();
    }

    private void checkUserDetailsFields(UserEntity userEntity, Map<String, String> errors) {
        this.checkUsername(userEntity, errors);
        this.checkDisplayName(userEntity, errors);
        this.checkEmail(userEntity, errors);
    }

    private void checkUsername(UserEntity userEntity, Map<String, String> errors) {
        String username = userEntity.getName();
        UsersResource.checkArgument(errors, StringUtils.isNotBlank(username), "name", this.i18nResolver.getText("usermanagement.validation.username.missing"));
        UsersResource.checkArgument(errors, StringUtils.length(username) <= 255, "name", this.i18nResolver.getText("usermanagement.validation.username.exceed.max.length", new Serializable[]{Integer.valueOf(255)}));
    }

    private void checkDisplayName(UserEntity userEntity, Map<String, String> errors) {
        UsersResource.checkArgument(errors, StringUtils.isNotBlank(userEntity.getDisplayName()), "display-name", this.i18nResolver.getText("usermanagement.validation.displayname.missing"));
    }

    private void checkEmail(UserEntity userEntity, Map<String, String> errors) {
        UsersResource.checkArgument(errors, EmailFunctions.VALID_EMAIL_ADDRESS.apply((Object)userEntity.getEmail()), "email", this.i18nResolver.getText("usermanagement.validation.email.invalid"));
    }

    private void checkPassword(PasswordEntity passwordEntity, Map<String, String> errors) {
        UsersResource.checkArgument(errors, passwordEntity != null && StringUtils.isNotBlank(passwordEntity.getValue()), "value", this.i18nResolver.getText("usermanagement.users.password.change.empty"));
    }
}

