/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource;

import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.manager.login.exception.InvalidResetPasswordTokenException;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.plugin.rest.entity.PasswordEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.UserController;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.PasswordScoreEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.MailServerConfigurationException;
import com.atlassian.crowd.plugin.usermanagement.rest.resource.BaseResource;
import com.atlassian.crowd.plugin.usermanagement.service.PasswordPolicyService;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupService;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="resetpassword")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
public class ResetPasswordResource
extends BaseResource {
    private static final Logger logger = LoggerFactory.getLogger(ResetPasswordResource.class);
    private final UserController userController;
    private final PasswordPolicyService passwordPolicyService;
    private final UserAndGroupService userAndGroupService;

    public ResetPasswordResource(UserController userController, PasswordPolicyService passwordPolicyService, UserAndGroupService userAndGroupService) {
        this.userController = userController;
        this.passwordPolicyService = passwordPolicyService;
        this.userAndGroupService = userAndGroupService;
    }

    @GET
    public Response canResetUserPassword(@QueryParam(value="username") String userName, @QueryParam(value="directoryId") long directoryId, @QueryParam(value="token") String token) {
        boolean canReset = this.userController.canResetUserPassword(directoryId, userName, token);
        return ResponseFactory.ok().entity((Object)(canReset ? this.tokenOk(userName) : this.invalidToken())).build();
    }

    @POST
    public Response resetUserPassword(@QueryParam(value="username") String userName, @QueryParam(value="directoryId") long directoryId, @QueryParam(value="token") String token, PasswordEntity password) throws InvalidCredentialException, DirectoryNotFoundException, UserNotFoundException, OperationFailedException, DirectoryPermissionException {
        try {
            this.userController.resetUserPassword(directoryId, userName, token, password.getValue());
            return ResponseFactory.noContent().build();
        }
        catch (InvalidResetPasswordTokenException e) {
            return ResponseFactory.ok().entity((Object)this.invalidToken()).build();
        }
    }

    @POST
    @Path(value="request")
    public Response sendForgotPasswordEmail(@QueryParam(value="username") String username) throws UserNotFoundException, DirectoryNotFoundException, InvalidEmailAddressException, OperationFailedException, MailServerConfigurationException {
        if (!StringUtils.isNotBlank(username)) {
            return ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)"Must provide a username to reset password.").build();
        }
        this.userController.sendForgotPasswordEmail(username);
        return ResponseFactory.noContent().build();
    }

    private ResetPasswordResponse invalidToken() {
        return new ResetPasswordResponse().setInvalidToken(true);
    }

    private ResetPasswordResponse tokenOk(String username) {
        ResetPasswordResponse response = new ResetPasswordResponse().setPolicyScore(PasswordScoreEntity.from(this.passwordPolicyService.getPolicyScore())).setUsername(username);
        try {
            User user = this.userAndGroupService.getUser(username);
            response.setDisplayName(user.getDisplayName()).setEmail(user.getEmailAddress());
        }
        catch (CrowdException e) {
            logger.error("Failed to load user: " + username, (Throwable)e);
        }
        return response;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static class ResetPasswordResponse {
        private Boolean invalidToken;
        private PasswordScoreEntity policyScore;
        private String username;
        private String displayName;
        private String email;

        @JsonProperty
        public Boolean getInvalidToken() {
            return this.invalidToken;
        }

        public ResetPasswordResponse setInvalidToken(Boolean invalidToken) {
            this.invalidToken = invalidToken;
            return this;
        }

        @JsonProperty
        public String getUsername() {
            return this.username;
        }

        public ResetPasswordResponse setUsername(String username) {
            this.username = username;
            return this;
        }

        @JsonProperty
        public PasswordScoreEntity getPolicyScore() {
            return this.policyScore;
        }

        public ResetPasswordResponse setPolicyScore(PasswordScoreEntity policyScore) {
            this.policyScore = policyScore;
            return this;
        }

        @JsonProperty
        public String getDisplayName() {
            return this.displayName;
        }

        public ResetPasswordResponse setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @JsonProperty
        public String getEmail() {
            return this.email;
        }

        public ResetPasswordResponse setEmail(String email) {
            this.email = email;
            return this;
        }
    }
}

