/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource;

import com.atlassian.crowd.embedded.api.PasswordScore;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.plugin.usermanagement.feature.FeatureGuard;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.PasswordExpiryEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.PasswordPolicyEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.PasswordRotationEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.PasswordScoreEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.resource.BaseResource;
import com.atlassian.crowd.plugin.usermanagement.service.PasswordPolicyService;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.ImmutableMap;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.Serializable;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="passwordpolicy")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@FeatureGuard(value="um.password.policy")
public class PasswordPolicyResource
extends BaseResource {
    private final PasswordPolicyService passwordPolicyService;
    private final I18nResolver i18nResolver;

    public PasswordPolicyResource(PasswordPolicyService passwordPolicyService, I18nResolver i18nResolver) {
        this.passwordPolicyService = passwordPolicyService;
        this.i18nResolver = i18nResolver;
    }

    @GET
    public Response getPasswordPolicy() {
        return ResponseFactory.ok(this.passwordPolicyService.getPasswordPolicy()).build();
    }

    @POST
    public Response setPasswordPolicy(PasswordPolicyEntity entity) {
        if (PasswordPolicyResource.isPasswordPolicyValid(entity)) {
            this.passwordPolicyService.setPolicyScore(entity.getPolicyScore().toEnum());
            this.passwordPolicyService.setMinimumPasswordRotation(entity.getMinimumPasswordRotation());
            this.passwordPolicyService.setExpiry(entity.getExpiry());
            return ResponseFactory.ok(this.passwordPolicyService.getPasswordPolicy()).build();
        }
        return ResponseFactory.status(Response.Status.BAD_REQUEST).build();
    }

    @Path(value="rotation")
    @POST
    public Response setMinimumPasswordRotation(PasswordRotationEntity passwordRotationEntity) {
        if (PasswordPolicyResource.isMinimumPasswordRotationValid(passwordRotationEntity)) {
            if (passwordRotationEntity.getEnforceRotation()) {
                this.passwordPolicyService.setMinimumPasswordRotation(passwordRotationEntity.getRotationCount());
            } else {
                this.passwordPolicyService.setMinimumPasswordRotation(0);
            }
            return ResponseFactory.ok(this.passwordPolicyService.getPasswordPolicy()).build();
        }
        return PasswordPolicyResource.buildErrors((Map<String, String>)ImmutableMap.of((Object)"passwordRotationCount", (Object)this.i18nResolver.getText("usermanagement.passwordpolicy.invalidRotation", new Serializable[]{Integer.valueOf(1), Integer.valueOf(9)})));
    }

    @Path(value="policyScore")
    @POST
    public Response setPasswordPolicyStrength(PasswordScoreEntity policyScore) {
        if (policyScore != null) {
            try {
                this.passwordPolicyService.setPolicyScore(policyScore.toEnum());
                return ResponseFactory.ok(this.passwordPolicyService.getPasswordPolicy()).build();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return PasswordPolicyResource.buildErrors((Map<String, String>)ImmutableMap.of((Object)"policyScore", (Object)this.i18nResolver.getText("usermanagement.passwordpolicy.invalidScore")));
    }

    @Path(value="expiry")
    @POST
    public Response setPasswordPolicyExpiry(PasswordExpiryEntity passwordExpiryEntity) {
        if (PasswordPolicyResource.isPasswordPolicyExpiryValid(passwordExpiryEntity)) {
            if (passwordExpiryEntity.getDoesExpire()) {
                this.passwordPolicyService.setExpiry(passwordExpiryEntity.getDaysTillExpiry());
            } else {
                this.passwordPolicyService.setExpiry(0);
            }
            return ResponseFactory.ok(this.passwordPolicyService.getPasswordPolicy()).build();
        }
        return PasswordPolicyResource.buildErrors((Map<String, String>)ImmutableMap.of((Object)"daysTillExpiry", (Object)this.i18nResolver.getText("usermanagement.passwordpolicy.invalidExpiry", new Serializable[]{Integer.valueOf(1), Integer.valueOf(999)})));
    }

    @Path(value="reset")
    @POST
    public Response resetAllPasswords() throws OperationFailedException {
        this.passwordPolicyService.resetAllPasswords();
        return ResponseFactory.ok().build();
    }

    private static boolean isPasswordPolicyExpiryValid(PasswordExpiryEntity expiry) {
        if (expiry == null) {
            return false;
        }
        return !expiry.getDoesExpire() || expiry.getDaysTillExpiry() <= 999 && expiry.getDaysTillExpiry() >= 1;
    }

    private static boolean isMinimumPasswordRotationValid(PasswordRotationEntity rotationEntity) {
        if (rotationEntity == null) {
            return false;
        }
        return !rotationEntity.getEnforceRotation() || rotationEntity.getRotationCount() <= 9 && rotationEntity.getRotationCount() >= 1;
    }

    private static boolean isPasswordPolicyValid(PasswordPolicyEntity entity) {
        return entity != null && PasswordPolicyResource.isMinimumPasswordRotationValid(new PasswordRotationEntity(entity.getMinimumPasswordRotation(), entity.getMinimumPasswordRotation() != 0)) && PasswordPolicyResource.isPasswordPolicyExpiryValid(new PasswordExpiryEntity(entity.getExpiry(), entity.getExpiry() != 0)) && entity.getPolicyScore().toEnum() != PasswordScore.UNKNOWN;
    }
}

