/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.UserController;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.MailServerConfigurationException;
import com.atlassian.crowd.plugin.usermanagement.rest.resource.BaseResource;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="forgotusername")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
public class ForgotUsernameResource
extends BaseResource {
    private final UserController userController;

    public ForgotUsernameResource(UserController userController) {
        this.userController = userController;
    }

    @POST
    public Response sendForgotUsernameEmail(@QueryParam(value="email") String email) throws DirectoryNotFoundException, InvalidEmailAddressException, OperationFailedException, MailServerConfigurationException {
        if (!StringUtils.isNotBlank(email)) {
            return ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)"Must provide a email address to retrieve usernames.").build();
        }
        this.userController.sendForgotUsernameEmail(email);
        return ResponseFactory.noContent().build();
    }
}

