/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource;

import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.UserController;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.NewPasswordEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.PasswordScoreEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.resource.BaseResource;
import com.atlassian.crowd.plugin.usermanagement.service.PasswordPolicyService;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupService;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.sal.api.user.UserManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@Path(value="changepassword")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ChangePasswordResource
extends BaseResource {
    private final UserController userController;
    private final PasswordPolicyService passwordPolicyService;
    private final UserAndGroupService userAndGroupService;
    private final UserManager userManager;

    public ChangePasswordResource(UserController userController, PasswordPolicyService passwordPolicyService, UserAndGroupService userAndGroupService, UserManager userManager) {
        this.userController = userController;
        this.passwordPolicyService = passwordPolicyService;
        this.userAndGroupService = userAndGroupService;
        this.userManager = userManager;
    }

    @POST
    public Response changePassword(@QueryParam(value="username") String userName, NewPasswordEntity passwordEntity) throws InvalidAuthenticationException, DirectoryPermissionException, OperationFailedException, InactiveAccountException, DirectoryNotFoundException, InvalidCredentialException, ExpiredCredentialException, UserNotFoundException {
        this.userController.changeUsersPassword(userName, passwordEntity.getCurrentPassword(), passwordEntity.getNewPassword());
        return ResponseFactory.ok().build();
    }

    @GET
    public Response getRelevantInfo() {
        if (this.userManager.getRemoteUser() == null) {
            return ResponseFactory.status(Response.Status.BAD_REQUEST).build();
        }
        String loggedInUserName = this.userManager.getRemoteUser().getUsername();
        return ResponseFactory.ok(this.createPasswordRequest(loggedInUserName)).build();
    }

    private ChangePasswordResponse createPasswordRequest(String username) {
        ChangePasswordResponse response = new ChangePasswordResponse().setUsername(username).setPolicyScore(PasswordScoreEntity.from(this.passwordPolicyService.getPolicyScore()));
        try {
            User user = this.userAndGroupService.getUser(username);
            response.setUsernameValid(true).setDisplayName(user.getDisplayName()).setEmail(user.getEmailAddress());
        }
        catch (CrowdException e) {
            response.setUsernameValid(false);
        }
        return response;
    }

    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static class ChangePasswordResponse {
        private boolean usernameValid;
        private PasswordScoreEntity policyScore;
        private String username;
        private String email;
        private String displayName;

        @JsonProperty
        public Boolean getUsernameValid() {
            return this.usernameValid;
        }

        public ChangePasswordResponse setUsernameValid(Boolean usernameValid) {
            this.usernameValid = usernameValid;
            return this;
        }

        @JsonProperty
        public String getUsername() {
            return this.username;
        }

        public ChangePasswordResponse setUsername(String username) {
            this.username = username;
            return this;
        }

        @JsonProperty
        public PasswordScoreEntity getPolicyScore() {
            return this.policyScore;
        }

        public ChangePasswordResponse setPolicyScore(PasswordScoreEntity policyScore) {
            this.policyScore = policyScore;
            return this;
        }

        @JsonProperty
        public String getDisplayName() {
            return this.displayName;
        }

        public ChangePasswordResponse setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @JsonProperty
        public String getEmail() {
            return this.email;
        }

        public ChangePasswordResponse setEmail(String email) {
            this.email = email;
            return this;
        }
    }
}

