/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource;

import com.atlassian.crowd.plugin.usermanagement.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import java.net.URI;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

public abstract class BaseResource {
    @Context
    private UriInfo uriInfo;
    @Context
    protected HttpServletRequest request;

    protected static void checkArgument(Map<String, String> errors, boolean expression, String field, String message) {
        if (!expression) {
            errors.put(field, message);
        }
    }

    protected static boolean hasErrors(Map<String, String> errors) {
        return !errors.isEmpty();
    }

    protected static Response buildErrors(Map<String, String> errors) {
        return ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)ErrorEntity.withFieldLevelError(errors)).build();
    }

    protected static Response buildErrors(String globalError) {
        return ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)ErrorEntity.withGenericError(globalError)).build();
    }

    protected URI getBaseUri() {
        return this.uriInfo.getBaseUri();
    }

    protected String getBaseUrl() {
        return this.uriInfo.getBaseUriBuilder().replacePath("/").build(new Object[0]).toString();
    }

    protected String getPath() {
        return this.uriInfo.getPath();
    }

    protected String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }
}

