/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.ApplicationController;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ApplicationDefaultsEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ApplicationEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ApplicationLicenseInfoEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.resource.BaseResource;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="apps")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ResourceFilters(value={AdminOnlyResourceFilter.class})
public class ApplicationsResource
extends BaseResource {
    private final ApplicationController applicationController;

    public ApplicationsResource(ApplicationController applicationController) {
        this.applicationController = applicationController;
    }

    @GET
    public Response getApplications() {
        List<ApplicationEntity> applications = this.applicationController.getApplications();
        return ResponseFactory.ok(applications).build();
    }

    @GET
    @Path(value="/seats")
    public Response getApplicationsSeats() throws DirectoryNotFoundException, OperationFailedException, CredentialsRequiredException {
        List<ApplicationLicenseInfoEntity> applications = this.applicationController.getApplicationLicenseEntities();
        return ResponseFactory.ok(applications).build();
    }

    @GET
    @Path(value="/defaults")
    public Response getDefaultApplications() {
        Iterable<ApplicationDefaultsEntity> applications = this.applicationController.getApplicationDefaults();
        return ResponseFactory.ok(applications).build();
    }

    @PUT
    @Path(value="/defaults")
    public Response setDefaultApplications(Map<String, Boolean> applicationIds) {
        Iterable<ApplicationDefaultsEntity> applications = this.applicationController.updateApplicationDefaults(applicationIds);
        return ResponseFactory.ok(applications).build();
    }

    @GET
    @Path(value="/{appId}/users")
    public Response getUsersForApplication(@PathParam(value="appId") String applicationLinkId, @DefaultValue(value="0") @QueryParam(value="start-index") int startIndex, @QueryParam(value="n") List<String> newUsersToPrepend, @DefaultValue(value="") @QueryParam(value="filter") String filter, @DefaultValue(value="50") @QueryParam(value="max-results") int maxResults) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        try {
            return ResponseFactory.ok(this.applicationController.getUsersWithAccessToApplication(filter, applicationLinkId, startIndex, maxResults, newUsersToPrepend, this.getBaseUri())).build();
        }
        catch (CredentialsRequiredException e) {
            return ResponseFactory.status(Response.Status.UNAUTHORIZED).build();
        }
    }
}

