/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.resource;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.application.bamboo.BambooApplicationType;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.crowd.plugin.usermanagement.feature.FeatureGuard;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkConfigService;
import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkFilteringService;
import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkProductService;
import com.atlassian.crowd.plugin.usermanagement.service.ReadOnlyApplicationLinkWithConfig;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ApplicationAccessError;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.AccessLevel;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.ConfigurationEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.GroupAttributesEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.host.HostEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.host.HostProductEntity;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.plugins.rest.common.security.jersey.AdminOnlyResourceFilter;
import com.atlassian.util.license.LicenseableApplication;
import com.atlassian.util.license.LicensedApplicationSource;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@Path(value="accessconfig")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ResourceFilters(value={AdminOnlyResourceFilter.class})
@FeatureGuard(value="um.renaissance")
public class AppAccessConfigResource {
    private final ApplicationLinkProductService productService;
    private final ApplicationLinkConfigService applicationLinkConfigService;
    private final ApplicationLinkFilteringService applicationLinkService;
    private final LicensedApplicationSource licensedApplicationSource;
    private boolean showSysAdmin = false;

    public AppAccessConfigResource(ApplicationLinkProductService productService, ApplicationLinkConfigService applicationLinkConfigService, ApplicationLinkFilteringService applicationLinkService, LicensedApplicationSource licensedApplicationSource) {
        this.productService = (ApplicationLinkProductService)Preconditions.checkNotNull((Object)productService);
        this.applicationLinkConfigService = (ApplicationLinkConfigService)Preconditions.checkNotNull((Object)applicationLinkConfigService);
        this.applicationLinkService = (ApplicationLinkFilteringService)Preconditions.checkNotNull((Object)applicationLinkService);
        this.licensedApplicationSource = (LicensedApplicationSource)Preconditions.checkNotNull((Object)licensedApplicationSource);
    }

    @GET
    public Response getConfig() throws Exception {
        ArrayList<ProductEntity> products = new ArrayList<ProductEntity>();
        Set<String> hostIDs = this.productService.getHostIDs();
        if (hostIDs != null && hostIDs.size() > 0) {
            for (String hostID : hostIDs) {
                products.addAll(this.getProductList(this.productService.get(hostID)));
            }
        }
        for (ReadOnlyApplicationLink link : this.applicationLinkService.getApplicationLinks()) {
            if (hostIDs != null && hostIDs.contains(link.getDisplayUrl().getAuthority() + link.getDisplayUrl().getPath())) continue;
            ReadOnlyApplicationLinkWithConfig linkWithConfig = this.applicationLinkConfigService.fetchConfigForApplication(link);
            if (linkWithConfig.getConfig().isRight()) {
                ConfigurationEntity config = (ConfigurationEntity)linkWithConfig.getConfig().right().get();
                HostEntity hostConfig = HostEntity.convert(link.getId().toString(), link.getName(), link.getDisplayUrl(), link.getRpcUrl(), config);
                products.add(this.buildProductEntity(link.getId().toString(), hostConfig, hostConfig.getProducts().get(0), false));
                continue;
            }
            String key = link.getType().getI18nKey();
            products.add(new ProductEntity(key, key, link.getName(), (List<GroupEntity>)ImmutableList.of(), false, true, null, this.getPermissionsUrl(link), ErrorEntity.withGenericError(((ApplicationAccessError)linkWithConfig.getConfig().left().get()).getReason())));
        }
        return ResponseFactory.ok(new ConfigEntity(products)).build();
    }

    private String getPermissionsUrl(ReadOnlyApplicationLink applicationLink) {
        if (applicationLink.getType() instanceof BambooApplicationType) {
            return applicationLink.getDisplayUrl() + "/admin/viewGlobalPermissions.action";
        }
        if (applicationLink.getType() instanceof ConfluenceApplicationType) {
            return applicationLink.getDisplayUrl() + "/admin/permissions/globalpermissions.action";
        }
        if (applicationLink.getType() instanceof JiraApplicationType) {
            return applicationLink.getDisplayUrl() + "/secure/admin/GlobalPermissions!default.jspa";
        }
        return null;
    }

    @PUT
    @Path(value="group")
    public Response updateGroup(@QueryParam(value="hostId") String hostId, @QueryParam(value="productId") String productId, GroupEntity groupEntity) throws Exception {
        HostEntity hostConfig = this.productService.get(hostId);
        HostProductEntity productConfig = null;
        for (HostProductEntity configurationEntity : hostConfig.getProducts()) {
            if (!configurationEntity.getId().equals(productId)) continue;
            productConfig = configurationEntity;
            break;
        }
        if (productConfig == null) {
            throw new Exception("unknown host/product");
        }
        Map<String, GroupAttributesEntity> useGroups = productConfig.getPermissions().getGroups();
        Map<String, GroupAttributesEntity> adminGroups = hostConfig.getAdministration().getPermissions().get((Object)AccessLevel.ADMIN).getGroups();
        if (groupEntity.use == Access.DIRECT != useGroups.containsKey(groupEntity.getName()) || groupEntity.admin == Access.DIRECT != adminGroups.containsKey(groupEntity.getName()) || groupEntity.defaultUse != (useGroups.containsKey(groupEntity.getName()) || useGroups.get(groupEntity.getName()).isDefault()) || groupEntity.defaultAdmin != (adminGroups.containsKey(groupEntity.getName()) || adminGroups.get(groupEntity.getName()).isDefault())) {
            if (groupEntity.use != Access.DIRECT) {
                useGroups.remove(groupEntity.getName());
            } else {
                useGroups.put(groupEntity.getName(), new GroupAttributesEntity(groupEntity.defaultUse));
            }
            if (groupEntity.admin != Access.DIRECT) {
                adminGroups.remove(groupEntity.getName());
            } else {
                adminGroups.put(groupEntity.getName(), new GroupAttributesEntity(groupEntity.defaultAdmin));
            }
            this.productService.put(hostConfig);
            return ResponseFactory.ok("{\"message\":\"updated\"}").build();
        }
        return ResponseFactory.ok("{\"message\":\"no change required\"}").build();
    }

    @POST
    @Path(value="group")
    public Response grantAccessToGroup(@QueryParam(value="hostId") String hostId, @QueryParam(value="productId") String productId, List<String> groupNames) throws Exception {
        HostEntity hostConfig = this.productService.get(hostId);
        HostProductEntity productConfig = null;
        for (HostProductEntity configurationEntity : hostConfig.getProducts()) {
            if (!configurationEntity.getId().equals(productId)) continue;
            productConfig = configurationEntity;
            break;
        }
        if (productConfig == null) {
            throw new Exception("unknown host/product");
        }
        ArrayList<GroupEntity> response = new ArrayList<GroupEntity>();
        for (String groupName : groupNames) {
            if (productConfig.getPermissions().getGroups().containsKey(groupName)) continue;
            productConfig.getPermissions().getGroups().put(groupName, new GroupAttributesEntity(false));
            response.add(new GroupEntity(groupName, Access.DIRECT, Access.NONE, false, false));
        }
        if (!response.isEmpty()) {
            this.productService.put(hostConfig);
            return ResponseFactory.ok(response).build();
        }
        return ResponseFactory.ok("{\"message\":\"no change required\"}").build();
    }

    @VisibleForTesting
    List<ProductEntity> getProductList(HostEntity hostConfig) {
        Optional mayBeLicensedApp = Iterables.tryFind(this.licensedApplicationSource.licensedApplications(), LicenseableApplication.nameFilterIgnoreCase(hostConfig.getDescription().getName()));
        if (!mayBeLicensedApp.isPresent()) {
            return Collections.emptyList();
        }
        ArrayList<ProductEntity> products = new ArrayList<ProductEntity>();
        for (HostProductEntity productConfig : hostConfig.getProducts()) {
            products.add(this.buildProductEntity(hostConfig.getDescription().getId(), hostConfig, productConfig, true));
        }
        return products;
    }

    protected ProductEntity buildProductEntity(String hostId, HostEntity hostConfig, HostProductEntity productConfig, boolean configurable) {
        ArrayList<GroupEntity> groups = new ArrayList<GroupEntity>();
        Map<String, GroupAttributesEntity> useGroups = productConfig.getPermissions().getGroups();
        HashMap adminGroups = productConfig.isPlatform() ? hostConfig.getAdministration().getPermissions().get((Object)AccessLevel.ADMIN).getGroups() : new HashMap();
        HashMap sysadminGroups = productConfig.isPlatform() ? hostConfig.getAdministration().getPermissions().get((Object)AccessLevel.SYSADMIN).getGroups() : new HashMap();
        for (String groupName : Sets.union(useGroups.keySet(), adminGroups.keySet())) {
            if (!this.showSysAdmin && sysadminGroups.containsKey(groupName)) continue;
            boolean use = useGroups.containsKey(groupName);
            boolean admin = adminGroups.containsKey(groupName);
            groups.add(new GroupEntity(groupName, Access.fromBoolean(use), Access.fromBoolean(admin, !productConfig.isPlatform()), use && useGroups.get(groupName).isDefault(), productConfig.isPlatform() && admin && ((GroupAttributesEntity)adminGroups.get(groupName)).isDefault()));
        }
        return new ProductEntity(hostId, productConfig.getId(), productConfig.getName(), groups, configurable, productConfig.isPlatform(), hostConfig.findPlatformProduct().getName(), hostConfig.getDescription().getDisplayURI().toString() + productConfig.getPermissionsPath(), null);
    }

    public static enum Access {
        DISABLED,
        NONE,
        DIRECT;


        public static Access fromBoolean(boolean access) {
            return access ? DIRECT : NONE;
        }

        public static Access fromBoolean(boolean access, boolean disabled) {
            return disabled ? DISABLED : Access.fromBoolean(access);
        }
    }

    @JsonAutoDetect
    public static class GroupEntity {
        private String name;
        private Access use;
        private Access admin;
        private boolean defaultUse;
        private boolean defaultAdmin;

        @JsonCreator
        public GroupEntity(@JsonProperty(value="name") String name, @JsonProperty(value="use") Access use, @JsonProperty(value="admin") Access admin, @JsonProperty(value="defaultUse") boolean defaultUse, @JsonProperty(value="defaultAdmin") boolean defaultAdmin) {
            this.name = name;
            this.use = use;
            this.admin = admin;
            this.defaultUse = defaultUse;
            this.defaultAdmin = defaultAdmin;
        }

        public String getName() {
            return this.name;
        }

        public Access getUse() {
            return this.use;
        }

        public Access getAdmin() {
            return this.admin;
        }

        public boolean isDefaultUse() {
            return this.defaultUse;
        }

        public boolean isDefaultAdmin() {
            return this.defaultAdmin;
        }
    }

    @JsonAutoDetect
    public static class ProductEntity {
        private String hostId;
        private String productId;
        private String name;
        private List<GroupEntity> groups;
        private boolean configurable;
        private boolean platform;
        private String platformProductName;
        private String permissionsUrl;
        private ErrorEntity errors;

        @JsonCreator
        public ProductEntity(@JsonProperty(value="hostId") String hostId, @JsonProperty(value="productId") String productId, @JsonProperty(value="name") String name, @JsonProperty(value="groups") List<GroupEntity> groups, @JsonProperty(value="configurable") boolean configurable, @JsonProperty(value="platform") boolean platform, @JsonProperty(value="platformProductName") String platformProductName, @JsonProperty(value="permissionsUrl") String permissionsUrl, @JsonProperty(value="errors") ErrorEntity errors) {
            this.hostId = hostId;
            this.productId = productId;
            this.name = name;
            this.groups = groups;
            this.configurable = configurable;
            this.platform = platform;
            this.platformProductName = platformProductName;
            this.permissionsUrl = permissionsUrl;
            this.errors = errors;
        }

        public String getHostId() {
            return this.hostId;
        }

        public String getProductId() {
            return this.productId;
        }

        public String getName() {
            return this.name;
        }

        public List<GroupEntity> getGroups() {
            return this.groups;
        }

        public boolean isConfigurable() {
            return this.configurable;
        }

        public boolean isPlatform() {
            return this.platform;
        }

        public String getPlatformProductName() {
            return this.platformProductName;
        }

        public String getPermissionsUrl() {
            return this.permissionsUrl;
        }

        public ErrorEntity getErrors() {
            return this.errors;
        }
    }

    @JsonAutoDetect
    public static class ConfigEntity {
        @JsonProperty
        private List<ProductEntity> products;

        @JsonCreator
        public ConfigEntity(@JsonProperty(value="products") List<ProductEntity> products) {
            this.products = products;
        }

        public List<ProductEntity> getProducts() {
            return this.products;
        }
    }
}

