/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.exception.mapper;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.UsersCausingLicenseException;
import com.atlassian.crowd.plugin.usermanagement.service.validation.LicenseExceeded;
import com.atlassian.crowd.plugin.usermanagement.service.validation.MembershipChangeCausingLicenseExceeded;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;

@Provider
public class UsersCausingLicenseExceptionMapper
implements ExceptionMapper<UsersCausingLicenseException> {
    private final I18nResolver i18nResolver;

    public UsersCausingLicenseExceptionMapper(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public Response toResponse(UsersCausingLicenseException e) {
        return ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)ErrorEntity.withGenericError(Collections2.transform(e.getInfo().entrySet(), (Function)new Function<Map.Entry<ReadOnlyApplicationLink, MembershipChangeCausingLicenseExceeded>, String>(){

            public String apply(Map.Entry<ReadOnlyApplicationLink, MembershipChangeCausingLicenseExceeded> input) {
                MembershipChangeCausingLicenseExceeded membershipChangeCausingLicenseExceeded = input.getValue();
                Set<String> userNames = membershipChangeCausingLicenseExceeded.getUsersToGrantAccess();
                LicenseExceeded licenseExceeded = membershipChangeCausingLicenseExceeded.getLicenseExceeded();
                return UsersCausingLicenseExceptionMapper.this.i18nResolver.getText("usermanagement.membership.add.users.license.exceeded.error", new Serializable[]{input.getKey().getName(), Integer.valueOf(licenseExceeded.getAvailable()), Integer.valueOf(licenseExceeded.getNeeded()), StringUtils.join(userNames, ", ")});
            }
        }))).build();
    }
}

