/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.exception.mapper;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.LicenseExceededException;
import com.atlassian.crowd.plugin.usermanagement.service.validation.LicenseExceeded;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.Serializable;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class LicenseExceededExceptionMapper
implements ExceptionMapper<LicenseExceededException> {
    private final I18nResolver i18nResolver;

    public LicenseExceededExceptionMapper(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public Response toResponse(LicenseExceededException e) {
        return ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)ErrorEntity.withGenericError(Collections2.transform(e.getInfo().entrySet(), (Function)new Function<Map.Entry<ReadOnlyApplicationLink, LicenseExceeded>, String>(){

            public String apply(Map.Entry<ReadOnlyApplicationLink, LicenseExceeded> input) {
                LicenseExceeded licenseExceeded = input.getValue();
                return LicenseExceededExceptionMapper.this.i18nResolver.getText("usermanagement.apps.license.exceeded.error", new Serializable[]{input.getKey().getName(), Integer.valueOf(licenseExceeded.getNeeded()), Integer.valueOf(licenseExceeded.getAvailable())});
            }
        }))).build();
    }
}

