/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.exception.mapper;

import com.atlassian.crowd.plugin.usermanagement.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.validation.ValidationHelpKey;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.plugins.rest.common.error.jersey.UncaughtExceptionEntity;
import com.atlassian.sal.api.message.I18nResolver;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.map.JsonMappingException;

@Provider
public class JsonMappingExceptionMapper
implements ExceptionMapper<JsonMappingException> {
    private final I18nResolver i18nResolver;
    @Context
    Request request;

    public JsonMappingExceptionMapper(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public Response toResponse(JsonMappingException e) {
        JsonMappingException.Reference reference;
        String fieldName;
        List path = e.getPath();
        if (path.size() > 0 && (fieldName = (reference = (JsonMappingException.Reference)path.get(path.size() - 1)).getFieldName()) != null) {
            Class<?> clazz = reference.getFrom().getClass();
            try {
                Field field = clazz.getDeclaredField(fieldName);
                if (field.isAnnotationPresent(ValidationHelpKey.class)) {
                    ValidationHelpKey annotation = field.getAnnotation(ValidationHelpKey.class);
                    return ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)ErrorEntity.withFieldLevelError(Collections.singletonMap(fieldName, this.i18nResolver.getText(annotation.value())))).build();
                }
            }
            catch (NoSuchFieldException e1) {
                // empty catch block
            }
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new UncaughtExceptionEntity((Throwable)e)).type(UncaughtExceptionEntity.variantFor((Request)this.request)).build();
    }
}

