/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.exception.mapper;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ApplicationAccessErrorException;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ApplicationAccessError;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.Serializable;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class ApplicationAccessErrorExceptionMapper
implements ExceptionMapper<ApplicationAccessErrorException> {
    private final I18nResolver i18nResolver;

    public ApplicationAccessErrorExceptionMapper(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public Response toResponse(ApplicationAccessErrorException e) {
        return ResponseFactory.status(Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ErrorEntity.withGenericError(Collections2.transform(e.getInfo().entrySet(), (Function)new Function<Map.Entry<ReadOnlyApplicationLink, ApplicationAccessError>, String>(){

            public String apply(Map.Entry<ReadOnlyApplicationLink, ApplicationAccessError> input) {
                return ApplicationAccessErrorExceptionMapper.this.i18nResolver.getText("usermanagement.apps.generic.error", new Serializable[]{input.getKey().getName(), input.getValue().getReason()});
            }
        }))).build();
    }
}

