/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.entity;

import com.atlassian.crowd.plugin.usermanagement.rest.entity.ApplicationValidationResultEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.ValidationMessageEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.ValidationResultEntity;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.annotate.JsonProperty;

public class ValidationResultsEntity
extends ValidationResultEntity {
    @JsonProperty
    private final Collection<ApplicationValidationResultEntity> references;
    private static final Predicate<ApplicationValidationResultEntity> HAS_ERROR_PREDICATE = new Predicate<ApplicationValidationResultEntity>(){

        public boolean apply(ApplicationValidationResultEntity input) {
            return input.hasErrors();
        }
    };

    public ValidationResultsEntity(List<ValidationMessageEntity> warnings, List<ValidationMessageEntity> errors, Collection<ApplicationValidationResultEntity> references) {
        super(warnings, errors);
        this.references = references;
    }

    public static ValidationResultsEntity error(ValidationMessageEntity singletonError) {
        return new ValidationResultsEntity(Collections.<ValidationMessageEntity>emptyList(), Collections.singletonList(singletonError), Collections.<ApplicationValidationResultEntity>emptyList());
    }

    public static ValidationResultsEntity applicationResults(Collection<ApplicationValidationResultEntity> applicationValidationResults) {
        return new ValidationResultsEntity(Collections.<ValidationMessageEntity>emptyList(), Collections.<ValidationMessageEntity>emptyList(), applicationValidationResults);
    }

    @Override
    @JsonProperty
    public boolean hasErrors() {
        return super.hasErrors() || this.references != null && Iterables.any(this.references, HAS_ERROR_PREDICATE);
    }
}

