/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.entity;

import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.LozengeEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.util.MessageHelper;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupCheckService;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.AccessLevel;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.Message;
import com.google.common.base.Function;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;

public class ListViewUser
extends UserEntity {
    @XmlAttribute(name="accessLevels")
    private final Map<String, AccessLevel> accessLevels;
    @XmlAttribute(name="unmodifiableMemberships")
    private final boolean unmodifiableMemberships;
    @XmlAttribute(name="unmodifiableDetails")
    private final boolean unmodifiableDetails;
    @XmlAttribute(name="disabledReason")
    private final String disabledReason;
    @XmlAttribute(name="lozenge")
    private final LozengeEntity lozenge;
    @XmlAttribute(name="isSelf")
    private final boolean isSelf;

    public ListViewUser(UserEntity userEntity, Map<String, AccessLevel> accessLevels, boolean unmodifiableMemberships, boolean unmodifiableDetails, String disabledReason, LozengeEntity lozenge, boolean isSelf) {
        super(userEntity.getName(), userEntity.getFirstName(), userEntity.getLastName(), userEntity.getDisplayName(), userEntity.getEmail(), userEntity.getPassword(), userEntity.isActive(), userEntity.getLink(), userEntity.getKey(), userEntity.getDirectoryId(), userEntity.getDirectoryName());
        this.accessLevels = accessLevels;
        this.unmodifiableMemberships = unmodifiableMemberships;
        this.unmodifiableDetails = unmodifiableDetails;
        this.disabledReason = disabledReason;
        this.lozenge = lozenge;
        this.isSelf = isSelf;
        this.setAttributes(userEntity.getAttributes());
    }

    public Map<String, AccessLevel> getAccessLevels() {
        return this.accessLevels;
    }

    public boolean hasUnmodifiableMemberships() {
        return this.unmodifiableMemberships;
    }

    public boolean hasUnmodifiableDetails() {
        return this.unmodifiableDetails;
    }

    public String getDisabledReason() {
        return this.disabledReason;
    }

    public LozengeEntity getLozenge() {
        return this.lozenge;
    }

    public boolean isSelf() {
        return this.isSelf;
    }

    public static ListViewUser fromUserEntity(UserEntity userEntity, UserAndGroupCheckService userAndGroupCheckService, I18nResolver i18nResolver) {
        String username = userEntity.getName();
        Option<Message> accessMessage = userAndGroupCheckService.canCurrentUserModifyUserAccess(username);
        Option<Message> dataMessage = userAndGroupCheckService.canCurrentUserModifyUserData(username);
        String disabledMessage = MessageHelper.getDisabledMessage(accessMessage, dataMessage, i18nResolver);
        LozengeEntity lozenge = userAndGroupCheckService.getUserLozenge(userEntity).getOrNull();
        return new ListViewUser(userEntity, null, accessMessage.isDefined(), dataMessage.isDefined(), disabledMessage, lozenge, userAndGroupCheckService.isCurrentUser(username));
    }

    public static Function<UserEntity, ListViewUser> fromUserEntityPredicate(final UserAndGroupCheckService userAndGroupCheckService, final I18nResolver i18nResolver) {
        return new Function<UserEntity, ListViewUser>(){

            public ListViewUser apply(UserEntity input) {
                return ListViewUser.fromUserEntity(input, userAndGroupCheckService, i18nResolver);
            }
        };
    }
}

