/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.entity;

import com.atlassian.crowd.plugin.usermanagement.constraints.Email;
import java.util.Collections;
import java.util.Set;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class InvitationsRequestEntity {
    @Size(min=1, message="usermanagement.validation.email.missing")
    @Email(message="usermanagement.validation.email.invalid")
    private final Set<String> emailAddresses;
    @Min(value=1L, message="usermanagement.users.invite.expiry.format.error")
    @Max(value=999L, message="usermanagement.users.invite.expiry.max")
    private final int expiryDays;
    private final Set<String> applications;
    private final String text;

    @JsonCreator
    public InvitationsRequestEntity(@JsonProperty(value="emailAddresses") Set<String> emailAddresses, @JsonProperty(value="expiryDays") Integer expiryDays, @JsonProperty(value="applications") Set<String> applications, @JsonProperty(value="text") String text) {
        this.emailAddresses = emailAddresses;
        this.expiryDays = expiryDays != null ? expiryDays : 7;
        this.applications = applications != null ? applications : Collections.emptySet();
        this.text = text;
    }

    public Set<String> getEmailAddresses() {
        return this.emailAddresses;
    }

    public int getExpiryDays() {
        return this.expiryDays;
    }

    public Set<String> getApplications() {
        return this.applications;
    }

    public String getText() {
        return this.text;
    }
}

