/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect
public class ErrorEntity {
    private final List<Error> errors;

    @JsonCreator
    private ErrorEntity(@JsonProperty(value="errors") List<Error> errors) {
        this.errors = errors;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public static ErrorEntity of(Throwable t) {
        return ErrorEntity.withGenericError(t.getMessage());
    }

    public static ErrorEntity withGenericError(String message) {
        return new ErrorEntity((List<Error>)ImmutableList.of((Object)new Error(message)));
    }

    public static ErrorEntity withGenericError(Iterable<String> messages) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String message : messages) {
            builder.add((Object)new Error(message));
        }
        return new ErrorEntity((List<Error>)builder.build());
    }

    public static ErrorEntity withFieldLevelError(Map<String, String> fieldErrors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<String, String> fieldError : fieldErrors.entrySet()) {
            builder.add((Object)new Error(fieldError.getKey(), fieldError.getValue()));
        }
        return new ErrorEntity((List<Error>)builder.build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorEntity that = (ErrorEntity)o;
        return !(this.errors != null ? !this.errors.equals(that.errors) : that.errors != null);
    }

    public int hashCode() {
        return this.errors != null ? this.errors.hashCode() : 0;
    }

    public String toString() {
        return "ErrorEntity{errors=" + this.errors + '}';
    }

    @JsonAutoDetect
    private static class Error {
        private final String message;
        private final String path;

        @JsonCreator
        private Error(@JsonProperty(value="path") String path, @JsonProperty(value="message") String message) {
            this.path = path;
            this.message = message;
        }

        private Error(String message) {
            this(null, message);
        }

        public String getMessage() {
            return this.message;
        }

        public String getPath() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Error error = (Error)o;
            if (this.message != null ? !this.message.equals(error.message) : error.message != null) {
                return false;
            }
            return !(this.path != null ? !this.path.equals(error.path) : error.path != null);
        }

        public int hashCode() {
            int result = this.message != null ? this.message.hashCode() : 0;
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Error{message='" + this.message + '\'' + ", path='" + this.path + '\'' + '}';
        }
    }
}

