/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.entity;

import com.atlassian.crowd.plugin.usermanagement.rest.entity.ApplicationDefaultsEntity;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ApplicationAccessError;
import com.atlassian.fugue.Option;
import java.net.URI;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect
public class ApplicationLicenseInfoEntity {
    private final ApplicationDefaultsEntity applicationEntity;
    private final Integer seatsAvailable;
    private final ApplicationAccessError error;
    private final Integer seatsTaken;
    private final Boolean isUnlimited;

    public ApplicationLicenseInfoEntity(ApplicationLicenseInfoEntityBuilder builder) {
        this.applicationEntity = builder.applicationEntity;
        this.seatsAvailable = (Integer)builder.seatsAvailable.getOrNull();
        this.error = (ApplicationAccessError)builder.error.getOrNull();
        this.seatsTaken = (Integer)builder.seatsTaken.getOrNull();
        this.isUnlimited = (Boolean)builder.isUnlimited.getOrNull();
    }

    public ApplicationAccessError getError() {
        return this.error;
    }

    public Integer getSeatsAvailable() {
        return this.seatsAvailable;
    }

    public Integer getSeatsTaken() {
        return this.seatsTaken;
    }

    public boolean getIsDefault() {
        return this.applicationEntity.getIsDefault();
    }

    public String getId() {
        return this.applicationEntity.getId();
    }

    public String getName() {
        return this.applicationEntity.getName();
    }

    public String getDescription() {
        return this.applicationEntity.getDescription();
    }

    public URI getIconUrl() {
        return this.applicationEntity.getIconUrl();
    }

    public Boolean isUnlimited() {
        return this.isUnlimited;
    }

    public static ApplicationLicenseInfoEntityBuilder builder(ApplicationDefaultsEntity applicationEntity) {
        return new ApplicationLicenseInfoEntityBuilder(applicationEntity);
    }

    public static class ApplicationLicenseInfoEntityBuilder {
        private final ApplicationDefaultsEntity applicationEntity;
        private Option<ApplicationAccessError> error;
        private Option<Integer> seatsAvailable;
        private Option<Integer> seatsTaken;
        private Option<Boolean> isUnlimited;

        public ApplicationLicenseInfoEntityBuilder(ApplicationDefaultsEntity applicationEntity) {
            this.applicationEntity = applicationEntity;
            this.error = Option.none();
            this.seatsAvailable = Option.none();
            this.seatsTaken = Option.none();
            this.isUnlimited = Option.none();
        }

        public ApplicationLicenseInfoEntity build() {
            return new ApplicationLicenseInfoEntity(this);
        }

        public ApplicationLicenseInfoEntityBuilder withError(Option<ApplicationAccessError> error) {
            this.error = error;
            return this;
        }

        public ApplicationLicenseInfoEntityBuilder withSeatsAvailable(Option<Integer> seatsAvailable) {
            this.seatsAvailable = seatsAvailable;
            return this;
        }

        public ApplicationLicenseInfoEntityBuilder withSeatsTaken(Option<Integer> seatsTaken) {
            this.seatsTaken = seatsTaken;
            return this;
        }

        public ApplicationLicenseInfoEntityBuilder withIsUnlimited(Option<Boolean> isUnlimited) {
            this.isUnlimited = isUnlimited;
            return this;
        }
    }
}

