/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.controller;

import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.ObjectAlreadyExistsException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.runtime.CrowdRuntimeException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.manager.login.ForgottenLoginManager;
import com.atlassian.crowd.manager.login.exception.InvalidResetPasswordTokenException;
import com.atlassian.crowd.manager.mail.MailSendException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.token.ExpirableUserToken;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.plugin.rest.entity.GroupEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntityList;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.util.EntityTranslator;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.crowd.plugin.usermanagement.common.UriBuilder;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.BaseController;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.BambooRenameEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.BulkAppAccessOperationResult;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.FullViewUser;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.GroupEntityWithAccessControl;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ListViewUser;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.LozengeEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.PublicSignUpFormEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.UserFormEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.ApplicationAccessErrorException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.EmailAlreadyExistsException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.EmailNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.InvalidInvitationException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.LicenseExceededException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.MailServerConfigurationException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.SignupNotEnabledException;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.UserModificationNotAllowedException;
import com.atlassian.crowd.plugin.usermanagement.rest.util.MessageHelper;
import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkConfigService;
import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkFilteringService;
import com.atlassian.crowd.plugin.usermanagement.service.ConflictingConfiguration;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.plugin.usermanagement.service.InvitationService;
import com.atlassian.crowd.plugin.usermanagement.service.ReadOnlyApplicationLinkWithConfig;
import com.atlassian.crowd.plugin.usermanagement.service.SendEmailService;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupCheckService;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupService;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningServiceFunctions;
import com.atlassian.crowd.plugin.usermanagement.service.validation.Failure;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.AccessLevel;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.ConfigurationEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.util.ImmutableMapUtils;
import com.atlassian.crowd.plugin.usermanagement.util.ApplicationLinkFunctions;
import com.atlassian.crowd.plugin.usermanagement.util.DefaultMessage;
import com.atlassian.crowd.plugin.usermanagement.util.ExplicitOrdering;
import com.atlassian.crowd.plugin.usermanagement.util.FailureUtils;
import com.atlassian.crowd.plugin.usermanagement.util.ServiceDeskValidationFunctions;
import com.atlassian.crowd.plugin.usermanagement.util.StringFunctions;
import com.atlassian.crowd.plugin.usermanagement.util.UserTemplateBuilder;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.service.SignupSettingsService;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.plugins.rest.common.Link;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.mail.internet.AddressException;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserController
extends BaseController {
    private static final int SELF_INVITE_EXPIRY_SECONDS = (int)TimeUnit.DAYS.toSeconds(1L);
    private static final Random USERNAME_RANDOM_GENERATOR = new Random();
    private static final int SMALL_RANGE_FOR_SUFFIXES = 100;
    private static final int SEQUENTIAL_LIMIT_FOR_SUFFIXES = 20;
    private static final String CROSS_PRODUCT_ADMINS = "site-admins";
    private static final String USERS_FILTER = "users";
    private static final String INVITATION_SEND_DATE = "invitationSendDate";
    private static final String INVITATION_EXPIRY_DATE = "invitationExpiryDate";
    private static final Logger logger = LoggerFactory.getLogger(UserController.class);
    @VisibleForTesting
    static final String ALL_USERS = "all";
    @VisibleForTesting
    static final String AGNI_GAPPS_USER_STATE_ATTRIBUTE_KEY = "agni.gapps.user.state";
    @VisibleForTesting
    static final String ACTIVATED_ATTRIBUTE_VALUE = "activated";
    private final DirectoryManager directoryManager;
    private final SendEmailService sendEmailService;
    private final ForgottenLoginManager forgottenLoginManager;
    private final ApplicationLinkFilteringService applicationLinkService;
    private final UserProvisioningService userProvisioningService;
    private final UserAndGroupService userAndGroupService;
    private final InvitationService invitationService;
    private final UserManager userManager;
    private final UserAndGroupCheckService userAndGroupCheckService;
    private final SignupSettingsService signupSettingsService;
    private final ApplicationLinkConfigService applicationLinkConfigService;
    private final Function<ReadOnlyApplicationLink, String> APPLICATION_LINK_TO_NAME = new Function<ReadOnlyApplicationLink, String>(){

        public String apply(ReadOnlyApplicationLink applicationLink) {
            return applicationLink.getName();
        }
    };
    private final Predicate<String> USERNAME_EXISTS_PREDICATE = new Predicate<String>(){

        public boolean apply(String username) {
            try {
                return UserController.this.userAndGroupService.userExists(username);
            }
            catch (DirectoryNotFoundException e) {
                throw new CrowdRuntimeException((Throwable)e);
            }
            catch (OperationFailedException e) {
                throw new CrowdRuntimeException((Throwable)e);
            }
        }
    };

    public UserController(DirectoryLocator directoryLocator, DirectoryManager directoryManager, SendEmailService sendEmailService, ForgottenLoginManager forgottenLoginManager, ApplicationLinkFilteringService applicationLinkService, UserProvisioningService userProvisioningService, UserAndGroupService userAndGroupService, I18nResolver i18nResolver, InvitationService invitationService, UserManager userManager, UserAndGroupCheckService userAndGroupCheckService, SignupSettingsService signupSettingsService, ApplicationLinkConfigService applicationLinkConfigService) {
        super(directoryLocator, i18nResolver);
        this.userAndGroupCheckService = (UserAndGroupCheckService)Preconditions.checkNotNull((Object)userAndGroupCheckService);
        this.applicationLinkService = (ApplicationLinkFilteringService)Preconditions.checkNotNull((Object)applicationLinkService);
        this.userProvisioningService = (UserProvisioningService)Preconditions.checkNotNull((Object)userProvisioningService);
        this.userAndGroupService = (UserAndGroupService)Preconditions.checkNotNull((Object)userAndGroupService);
        this.directoryManager = (DirectoryManager)Preconditions.checkNotNull((Object)directoryManager);
        this.sendEmailService = (SendEmailService)Preconditions.checkNotNull((Object)sendEmailService);
        this.forgottenLoginManager = (ForgottenLoginManager)Preconditions.checkNotNull((Object)forgottenLoginManager);
        this.invitationService = (InvitationService)Preconditions.checkNotNull((Object)invitationService);
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
        this.signupSettingsService = (SignupSettingsService)Preconditions.checkNotNull((Object)signupSettingsService);
        this.applicationLinkConfigService = (ApplicationLinkConfigService)Preconditions.checkNotNull((Object)applicationLinkConfigService);
    }

    public UserEntity getUser(String userName, URI baseUri) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException, DirectoryPermissionException {
        UserEntity userEntity = this.userAndGroupService.getUserEntity(userName, baseUri, true);
        Map<String, AccessLevel> transform = this.translateAccessLevelRepresentation(this.userProvisioningService.getAccessLevel(userName, this.applicationLinkConfigService.fetchAllConfigsAsMapForAllApplications()));
        Option<Message> accessMessage = this.userAndGroupCheckService.canCurrentUserModifyUserAccess(userName);
        Option<Message> dataMessage = this.userAndGroupCheckService.canCurrentUserModifyUserData(userName);
        LozengeEntity lozenge = this.userAndGroupCheckService.getUserLozenge(userEntity).getOrNull();
        User user = this.directoryManager.findUserByName(this.getDirectoryId(), userName);
        return new FullViewUser(userEntity, (Map<String, AccessLevel>)ImmutableMap.copyOf(transform), accessMessage.isDefined(), dataMessage.isDefined(), MessageHelper.getDisabledMessage(accessMessage, dataMessage, this.i18nResolver), lozenge, this.userAndGroupCheckService.isCurrentUser(userName), user, this.getAIDFromUser(userName).getOrNull());
    }

    public UserEntity addUser(UserEntity userEntity, URI baseURI, Set<String> applications) throws DirectoryNotFoundException, OperationFailedException, DirectoryPermissionException, UserAlreadyExistsException, InvalidUserException, InvalidCredentialException, InvalidEmailAddressException, UserNotFoundException, IOException, GroupNotFoundException, ReadOnlyGroupException, MembershipAlreadyExistsException, ResponseException, LicenseExceededException, ApplicationAccessErrorException, MailServerConfigurationException, EmailAlreadyExistsException {
        String email = userEntity.getEmail();
        if (this.emailExists(email)) {
            throw new EmailAlreadyExistsException(email);
        }
        UserTemplate userTemplate = UserController.newUserTemplate(userEntity, this.getDirectoryId());
        boolean setPasswordRequired = false;
        if (userEntity.getPassword() == null || StringUtils.isBlank(userEntity.getPassword().getValue())) {
            setPasswordRequired = true;
        }
        UserProvisioningService.ReservedApplicationAccess reservation = this.reserveApplicationAccess(this.appIdToAppLink(applications));
        User user = this.addUser(userTemplate, setPasswordRequired ? PasswordCredential.NONE : PasswordCredential.unencrypted((String)userEntity.getPassword().getValue()));
        if (setPasswordRequired) {
            try {
                this.sendEmailService.sendCreateUserPasswordEmail(user, 7);
            }
            catch (AddressException e) {
                throw new InvalidEmailAddressException((Throwable)e);
            }
            catch (MailSendException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        reservation.apply(ImmutableSet.of((Object)user.getName()));
        Link userLink = LinkUriHelper.buildUserLink(baseURI, user.getName());
        return EntityTranslator.toUserEntity(user, userLink);
    }

    public void removeAIDFromUser(String userName) throws UserNotFoundException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException {
        this.directoryManager.removeUserAttributes(this.getDirectoryId(), userName, "atlassianid.openid.identity");
    }

    private Option<String> getAIDFromUser(String userName) throws UserNotFoundException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException {
        UserWithAttributes user = this.directoryManager.findUserWithAttributesByName(this.getDirectoryId(), userName);
        Set possibleValues = user.getValues("atlassianid.openid.identity");
        if (possibleValues == null || possibleValues.isEmpty()) {
            return Option.none();
        }
        return Option.some(possibleValues.iterator().next());
    }

    public void updateUserActive(String userName, URI baseURI, boolean active) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException, InvalidUserException, DirectoryPermissionException, UserModificationNotAllowedException {
        if (this.userAndGroupCheckService.isCurrentUser(userName)) {
            throw new UserModificationNotAllowedException(new DefaultMessage("usermanagement.users.deactivate.self.error", new Serializable[0]));
        }
        Option<Message> modificationAllowed = this.userAndGroupCheckService.canCurrentUserModifyUserData(userName);
        if (modificationAllowed.isDefined()) {
            throw new UserModificationNotAllowedException((Message)modificationAllowed.get());
        }
        UserEntity userEntity = this.userAndGroupService.getUserEntity(userName, baseURI, false);
        UserTemplateWithAttributes user = (UserTemplateWithAttributes)EntityTranslator.fromUserEntity(userEntity);
        user.setActive(active);
        user.setDirectoryId(this.getDirectoryId());
        this.directoryManager.updateUser(this.getDirectoryId(), (UserTemplate)user);
    }

    public Either<ConflictingConfiguration, UserEntity> revokeApplicationAccess(String userName, URI baseURI, String applicationToRevoke) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException, GroupNotFoundException, ReadOnlyGroupException, DirectoryPermissionException, CredentialsRequiredException, ResponseException {
        UserEntity userEntity = this.userAndGroupService.getUserEntity(userName, baseURI, false);
        Map<ReadOnlyApplicationLink, ConfigurationEntity> appConfigs = this.applicationLinkConfigService.fetchAllConfigsAsMapForAllApplications();
        Map<ReadOnlyApplicationLink, AccessLevel> current = this.userProvisioningService.getAccessLevel(userName, appConfigs);
        Option<ReadOnlyApplicationLink> found = com.atlassian.fugue.Iterables.findFirst(current.keySet(), Predicates.compose((Predicate)Predicates.equalTo((Object)applicationToRevoke), ApplicationLinkFunctions.APPLICATION_LINK_STRING_ID_GETTER));
        if (found.isDefined()) {
            HashMap toUpdate = Maps.newHashMap(current);
            toUpdate.put(found.get(), AccessLevel.NONE);
            Either<ConflictingConfiguration, Set<String>> result = this.userProvisioningService.updateAccessLevel(userName, toUpdate, true, appConfigs);
            return result.right().map(Functions.constant((Object)userEntity));
        }
        return Either.right(userEntity);
    }

    public UserEntity updateUser(UserEntity userEntity, URI baseURI, boolean expandAttributes) throws UserNotFoundException, InvalidUserException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException, UserModificationNotAllowedException, EmailAlreadyExistsException {
        boolean updateEmail;
        String name = userEntity.getName();
        Option<Message> modificationAllowed = this.userAndGroupCheckService.canCurrentUserModifyUserData(name);
        if (modificationAllowed.isDefined()) {
            throw new UserModificationNotAllowedException((Message)modificationAllowed.get());
        }
        String newEmail = userEntity.getEmail();
        String storedEmail = this.directoryManager.findUserByName(this.getDirectoryId(), name).getEmailAddress();
        boolean bl = updateEmail = storedEmail == null || !storedEmail.equalsIgnoreCase(newEmail);
        if (updateEmail && this.emailExists(newEmail)) {
            throw new EmailAlreadyExistsException(newEmail);
        }
        UserTemplateWithAttributes user = (UserTemplateWithAttributes)EntityTranslator.fromUserEntity(userEntity);
        user.setDirectoryId(this.getDirectoryId());
        this.directoryManager.updateUser(this.getDirectoryId(), (UserTemplate)user);
        return this.userAndGroupService.getUserEntity(name, baseURI, expandAttributes);
    }

    public void renameUser(String oldName, UserFormEntity userFormEntity) throws DirectoryPermissionException, DirectoryNotFoundException, UserNotFoundException, InvalidUserException, OperationFailedException, UserAlreadyExistsException {
        if (this.userAndGroupCheckService.canCurrentUserModifyUserData(oldName).isDefined()) {
            throw new UserModificationNotAllowedException(new DefaultMessage("usermanagement.error.modifysysadmin.user", new Serializable[0]));
        }
        UserWithAttributes user = this.directoryManager.findUserWithAttributesByName(this.getDirectoryId(), oldName);
        if (ACTIVATED_ATTRIBUTE_VALUE.equals(user.getValue(AGNI_GAPPS_USER_STATE_ATTRIBUTE_KEY))) {
            throw new UserModificationNotAllowedException(new DefaultMessage("usermanagement.warning.rename.googleapps", new Serializable[]{user.getDisplayName()}));
        }
        String newName = userFormEntity.getName();
        this.directoryManager.renameUser(this.getDirectoryId(), oldName, newName);
        try {
            this.renameBambooUser(oldName, newName);
        }
        catch (OperationFailedException e) {
            this.directoryManager.renameUser(this.getDirectoryId(), newName, oldName);
            throw e;
        }
    }

    @VisibleForTesting
    void renameBambooUser(final String oldUsername, final String newUsername) throws OperationFailedException {
        String url = UriBuilder.fromPath("/rest/admin/latest/user").queryParam("externalRename", true).build().toString();
        for (final ReadOnlyApplicationLink link : this.applicationLinkService.getApplicationLinks()) {
            if (!link.getType().getI18nKey().equals("applinks.bamboo")) continue;
            try {
                Option error = (Option)((ApplicationLinkRequest)((ApplicationLinkRequest)link.createAuthenticatedRequestFactory().createRequest(Request.MethodType.POST, url).setHeader("Content-Type", "application/json")).setEntity((Object)new BambooRenameEntity(newUsername, oldUsername))).executeAndReturn((ReturningResponseHandler)new ReturningResponseHandler<Response, Option<String>>(){

                    public Option<String> handle(Response response) throws ResponseException {
                        if (response.isSuccessful()) {
                            return Option.none();
                        }
                        logger.error("Error renaming a user in Bamboo {}: {} {}", new Object[]{link.getName(), response.getStatusCode(), response.getStatusText()});
                        return Option.some(UserController.this.i18nResolver.getText("usermanagement.users.error.bamboo.rename", new Serializable[]{oldUsername, newUsername}));
                    }
                });
                if (!error.isDefined()) continue;
                throw new OperationFailedException((String)error.get());
            }
            catch (ResponseException e) {
                logger.error("Response error obtained while trying to rename a user in Bamboo.", (Throwable)e);
                throw new OperationFailedException(this.i18nResolver.getText("usermanagement.users.error.bamboo.rename", new Serializable[]{oldUsername, newUsername}));
            }
            catch (CredentialsRequiredException e) {
                logger.error("Invalid credentials to rename a user in Bamboo.", (Throwable)e);
                throw new OperationFailedException(this.i18nResolver.getText("usermanagement.users.error.bamboo.rename", new Serializable[]{oldUsername, newUsername}));
            }
        }
    }

    private Set<ReadOnlyApplicationLink> appIdToAppLink(Collection<String> applicationIds) {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(this.applicationLinkService.getApplicationLinks(), (Predicate)Predicates.compose((Predicate)Predicates.in(applicationIds), ApplicationLinkFunctions.APPLICATION_LINK_STRING_ID_GETTER)));
    }

    public Iterable<UserEntity> findUsersByName(@Nullable String nameFilter, int startIndex, int maxResults, URI baseUri, List<String> userFilters, List<Boolean> activeFilters, List<String> newUserNamesToPrepend) throws DirectoryNotFoundException, OperationFailedException, UserNotFoundException {
        List<SearchRestriction> restrictions = this.applyFilters(nameFilter, userFilters, activeFilters);
        NullRestriction combinedRestriction = restrictions.isEmpty() ? NullRestrictionImpl.INSTANCE : Combine.allOf(restrictions);
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)combinedRestriction).startingAt(startIndex).returningAtMost(maxResults);
        ImmutableList<User> users = UserController.explicitlyOrderUsersByUsername(newUserNamesToPrepend, this.directoryManager.searchUsers(this.getDirectoryId(), query));
        Directory directory = this.directoryManager.findDirectoryById(this.getDirectoryId());
        return Lists.transform(this.getUserWithAttributes((List<User>)users), (Function)UserController.toUserEntity(directory, baseUri));
    }

    @VisibleForTesting
    protected List<SearchRestriction> applyFilters(@Nullable String nameFilter, List<String> userFilters, List<Boolean> activeFilters) {
        ArrayList orRestrictions;
        ArrayList userRestrictions = Lists.newArrayList();
        if (StringUtils.isNotEmpty(nameFilter)) {
            userRestrictions.add(Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)nameFilter), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)nameFilter), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)nameFilter)}));
        }
        if (userFilters != null && !userFilters.isEmpty()) {
            orRestrictions = Lists.newArrayList();
            if (userFilters.contains(ServiceDeskValidationFunctions.SERVICE_DESK_REQUESTOR_KEY)) {
                orRestrictions.add(Restriction.on((Property)PropertyUtils.ofTypeString((String)ServiceDeskValidationFunctions.SERVICE_DESK_REQUESTOR_KEY)).exactlyMatching((Object)"true"));
            }
            if (userFilters.contains(USERS_FILTER)) {
                orRestrictions.add(Restriction.on((Property)PropertyUtils.ofTypeString((String)ServiceDeskValidationFunctions.SERVICE_DESK_REQUESTOR_KEY)).isNull());
            }
            userRestrictions.add(Combine.anyOf((Collection)orRestrictions));
        }
        if (activeFilters != null && !activeFilters.isEmpty()) {
            orRestrictions = Lists.newArrayList();
            for (Boolean activeState : activeFilters) {
                orRestrictions.add(Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)activeState));
            }
            userRestrictions.add(Combine.anyOf((Collection)orRestrictions));
        }
        return userRestrictions;
    }

    private List<UserWithAttributes> getUserWithAttributes(List<User> users) throws DirectoryNotFoundException, UserNotFoundException, OperationFailedException {
        ImmutableList.Builder usersWithAttributesBuilder = ImmutableList.builder();
        for (User user : users) {
            usersWithAttributesBuilder.add((Object)this.directoryManager.findUserWithAttributesByName(this.getDirectoryId(), user.getName()));
        }
        return usersWithAttributesBuilder.build();
    }

    public Iterable<UserEntity> findUsersByGroup(String groupName, int startIndex, int maxResults, List<String> newUserNamesToPrepend, URI baseUri) throws DirectoryNotFoundException, OperationFailedException, UserNotFoundException {
        MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(startIndex).returningAtMost(maxResults);
        ImmutableList<User> users = UserController.explicitlyOrderUsersByUsername(newUserNamesToPrepend, this.directoryManager.searchDirectGroupRelationships(this.getDirectoryId(), query));
        Directory directory = this.directoryManager.findDirectoryById(this.getDirectoryId());
        return Lists.transform(this.getUserWithAttributes((List<User>)users), (Function)UserController.toUserEntityWithAccessControl(directory, baseUri, this.userAndGroupCheckService, groupName, this.i18nResolver));
    }

    public GroupEntityList getDirectGroups(final String userName, int maxResults, int startIndex, List<String> newGroupNamesToPrepend, final URI baseUri) throws DirectoryNotFoundException, OperationFailedException {
        final boolean cannotModifyUser = this.userAndGroupCheckService.canCurrentUserModifyUserAccess(userName).isDefined();
        MembershipQuery query = QueryBuilder.createMembershipQuery((int)maxResults, (int)startIndex, (boolean)false, (EntityDescriptor)EntityDescriptor.group(), Group.class, (EntityDescriptor)EntityDescriptor.user(), (String)userName);
        List groups = this.directoryManager.searchNestedGroupRelationships(this.getDirectoryId(), query);
        try {
            List<Group> orderedGroups = this.explictlyPrependGroupsByGroupname(newGroupNamesToPrepend, groups);
            return new GroupEntityList(Lists.transform(orderedGroups, (Function)new Function<Group, GroupEntity>(){

                public GroupEntity apply(Group group) {
                    boolean isUnmodifiable = UserController.this.userAndGroupCheckService.canCurrentUserModifyGroup(group.getName()).isDefined() || cannotModifyUser;
                    boolean isLastAdminGroup = UserController.this.userAndGroupCheckService.isCurrentUser(userName) && UserController.this.userAndGroupCheckService.willCurrentUserBeDemotedByLeavingGroup(group.getName()).isDefined();
                    return GroupEntityWithAccessControl.newGroupEntityWithAccessControl(group.getName(), group.getDescription(), group.isActive(), isUnmodifiable, isLastAdminGroup, baseUri);
                }
            }));
        }
        catch (GroupNotFoundException e) {
            throw new OperationFailedException("Group not found during ordering", (Throwable)e);
        }
    }

    public GroupEntity getDirectGroup(String userName, String groupName, URI baseUri) throws DirectoryNotFoundException, OperationFailedException, MembershipNotFoundException {
        boolean isMember = this.directoryManager.isUserNestedGroupMember(this.getDirectoryId(), userName, groupName);
        if (!isMember) {
            throw new MembershipNotFoundException(userName, groupName);
        }
        boolean isUnmodifiable = this.userAndGroupCheckService.canCurrentUserModifyGroup(groupName).isDefined() || this.userAndGroupCheckService.canCurrentUserModifyUserAccess(userName).isDefined();
        boolean isLastAdminGroup = this.userAndGroupCheckService.willCurrentUserBeDemotedByLeavingGroup(groupName).isDefined();
        return GroupEntityWithAccessControl.newMinimalGroupEntityWithAccessControl(groupName, baseUri, isUnmodifiable, isLastAdminGroup);
    }

    private static UserEntityTransformer toUserEntity(Directory directory, URI baseUri) {
        return new UserEntityTransformer(directory, baseUri);
    }

    private static UserEntityWithAccessControlTransformer toUserEntityWithAccessControl(Directory directory, URI baseUri, UserAndGroupCheckService userAndGroupCheckService, String groupName, I18nResolver i18nResolver) {
        return new UserEntityWithAccessControlTransformer(directory, baseUri, userAndGroupCheckService, groupName, i18nResolver);
    }

    public void sendForgotPasswordEmail(String username) throws OperationFailedException, InvalidEmailAddressException, DirectoryNotFoundException, UserNotFoundException, MailServerConfigurationException {
        User user = this.directoryManager.findUserByName(this.getDirectoryId(), username);
        try {
            this.sendEmailService.sendForgotPasswordEmail(user);
        }
        catch (AddressException e) {
            throw new InvalidEmailAddressException((Throwable)e);
        }
        catch (MailSendException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public void sendForgotUsernameEmail(String email) throws OperationFailedException, InvalidEmailAddressException, DirectoryNotFoundException, MailServerConfigurationException {
        EntityQuery<User> query = this.buildUserQueryByEmail(email);
        List users = this.directoryManager.searchUsers(this.getDirectoryId(), query);
        try {
            this.sendEmailService.sendForgotUsernameEmail(email, users);
        }
        catch (AddressException e) {
            throw new InvalidEmailAddressException((Throwable)e);
        }
        catch (MailSendException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @VisibleForTesting
    EntityQuery<User> buildUserQueryByEmail(String email) {
        return QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.EMAIL).exactlyMatching((Object)email)).returningAtMost(-1);
    }

    public void updateUserPassword(String username, String password) throws InvalidCredentialException, OperationFailedException, UserNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, UserModificationNotAllowedException {
        Option<Message> modificationAllowed = this.userAndGroupCheckService.canCurrentUserModifyUserData(username);
        if (modificationAllowed.isDefined()) {
            throw new UserModificationNotAllowedException((Message)modificationAllowed.get());
        }
        this.directoryManager.updateUserCredential(this.getDirectoryId(), username, PasswordCredential.unencrypted((String)password));
    }

    public boolean canResetUserPassword(long directoryId, String username, String token) {
        return this.forgottenLoginManager.isValidResetToken(directoryId, username, token);
    }

    public void changeUsersPassword(String username, String oldPassword, String newPassword) throws InvalidAuthenticationException, OperationFailedException, InactiveAccountException, DirectoryNotFoundException, ExpiredCredentialException, UserNotFoundException, InvalidCredentialException, DirectoryPermissionException {
        this.directoryManager.authenticateUser(this.getDirectoryId(), username, PasswordCredential.unencrypted((String)oldPassword));
        this.directoryManager.updateUserCredential(this.getDirectoryId(), username, PasswordCredential.unencrypted((String)newPassword));
    }

    public void resetUserPassword(long directoryId, String username, String token, String password) throws DirectoryPermissionException, DirectoryNotFoundException, UserNotFoundException, InvalidCredentialException, InvalidResetPasswordTokenException, OperationFailedException {
        if (!this.forgottenLoginManager.isValidResetToken(directoryId, username, token)) {
            throw new InvalidResetPasswordTokenException("Invalid reset password token");
        }
        this.forgottenLoginManager.resetUserCredential(directoryId, username, PasswordCredential.unencrypted((String)password), token);
    }

    /*
     * Exception decompiling
     */
    public BulkAppAccessOperationResult grantApplicationAccess(Collection<String> userNames, Iterable<ReadOnlyApplicationLinkWithConfig> applicationLinks) throws DirectoryNotFoundException, OperationFailedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public BulkAppAccessOperationResult grantApplicationAccess(String group, Iterable<ReadOnlyApplicationLinkWithConfig> applicationLinks) throws DirectoryNotFoundException, OperationFailedException {
        Collection<Object> users = new HashSet();
        if (group.equals(ALL_USERS)) {
            users = this.userAndGroupService.getAllUsersValidForApplicationAccess();
        } else {
            Option<ReadOnlyApplicationLink> link;
            ReadOnlyApplicationLinkWithConfig sourceApplicationLink = null;
            for (ReadOnlyApplicationLinkWithConfig applicationLink : applicationLinks) {
                if (!applicationLink.getId().get().equals(group)) continue;
                sourceApplicationLink = applicationLink;
                break;
            }
            if (sourceApplicationLink == null && (link = this.applicationLinkService.getApplicationLink(group)).isDefined()) {
                sourceApplicationLink = this.applicationLinkConfigService.fetchConfigForApplication((ReadOnlyApplicationLink)link.get());
            }
            if (sourceApplicationLink != null && sourceApplicationLink.getConfig().isRight()) {
                users = this.userProvisioningService.findUsernamesGrantedAccessToApplication((ConfigurationEntity)sourceApplicationLink.getConfig().right().get());
            }
        }
        return this.grantApplicationAccess(users, applicationLinks);
    }

    public Set<String> inviteUser(Set<String> emailAddresses, Set<String> applicationIds, int tokenExpiryDays, @Nullable String personalNote, String continueUrl) throws LicenseExceededException, DirectoryNotFoundException, UserNotFoundException, OperationFailedException, InvalidCredentialException, InvalidUserException, UserAlreadyExistsException, DirectoryPermissionException, MailServerConfigurationException, MailSendException, AddressException {
        UserProvisioningService.ReservedApplicationAccess reservation = this.reserveApplicationAccess(emailAddresses.size(), this.appIdToAppLink(applicationIds));
        Collection loweredEmailAddresses = Collections2.transform(emailAddresses, StringFunctions.toLowerCase());
        UserProfile inviterProfile = this.userManager.getRemoteUser();
        User inviter = this.directoryManager.findUserByName(this.getDirectoryId(), inviterProfile.getUsername());
        HashSet usersAdded = Sets.newHashSet();
        for (String emailAddress : loweredEmailAddresses) {
            boolean emailExists = this.emailExists(emailAddress);
            if (emailExists) {
                this.sendEmailService.sendInviteUserEmailExistingUser(inviter, emailAddress);
                continue;
            }
            String name = (String)Iterables.find(UserController.generateUsernames(emailAddress, null), (Predicate)Predicates.not(this.USERNAME_EXISTS_PREDICATE), null);
            if (name == null) {
                throw new OperationFailedException("Cannot generate a username for the new user");
            }
            UserTemplate userTemplate = UserController.newUserTemplate(name, emailAddress, this.getDirectoryId());
            DateTime now = DateTime.now();
            Map<String, Set<String>> attributes = UserController.createAttributesMap(INVITATION_SEND_DATE, now.getMillis(), INVITATION_EXPIRY_DATE, now.plusDays(tokenExpiryDays).getMillis());
            User user = this.addUserWithAttributes(userTemplate, PasswordCredential.NONE, attributes);
            usersAdded.add(name);
            this.sendEmailService.sendCreateUserPasswordEmail(user, tokenExpiryDays);
        }
        reservation.apply(usersAdded);
        return usersAdded;
    }

    private User addUser(UserTemplate userTemplate, PasswordCredential passwordCredential) throws DirectoryPermissionException, DirectoryNotFoundException, InvalidCredentialException, InvalidUserException, OperationFailedException, UserAlreadyExistsException {
        return this.directoryManager.addUser(this.getDirectoryId(), userTemplate, passwordCredential);
    }

    private User addUserWithAttributes(UserTemplate userTemplate, PasswordCredential passwordCredential, Map<String, Set<String>> attributes) throws DirectoryPermissionException, DirectoryNotFoundException, InvalidCredentialException, InvalidUserException, OperationFailedException, UserAlreadyExistsException, UserNotFoundException {
        User user = this.addUser(userTemplate, passwordCredential);
        this.directoryManager.storeUserAttributes(this.getDirectoryId(), userTemplate.getName(), attributes);
        return user;
    }

    private Map<ReadOnlyApplicationLinkWithConfig, Integer> getAvailableSeatsForDefaultApplications() {
        return this.getAvailableSeatsForApplications(this.userProvisioningService.getDefaultApplications());
    }

    private Map<ReadOnlyApplicationLinkWithConfig, Integer> getAvailableSeatsForApplications(Iterable<ReadOnlyApplicationLink> readOnlyApplicationLinks) {
        ImmutableMap<ReadOnlyApplicationLinkWithConfig, Option<Integer>> seats = ImmutableMapUtils.toMap(this.applicationLinkConfigService.fetchAllConfigsForApplications(readOnlyApplicationLinks), UserProvisioningServiceFunctions.calculateAvailableSeatsForApplication(this.userProvisioningService));
        return ImmutableMapUtils.collectByValue(seats, Functions.identity());
    }

    private boolean emailExists(String emailAddress) throws DirectoryNotFoundException, OperationFailedException {
        return !this.directoryManager.searchUsers(this.getDirectoryId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.EMAIL).exactlyMatching((Object)emailAddress)).returningAtMost(1)).isEmpty();
    }

    public Option<ExpirableUserToken> getInvitation(String token) {
        return this.invitationService.getInvitation(token);
    }

    public UserEntity addUserWithToken(UserEntity inputUserEntity, URI baseURI, String token, String serverName) throws UserAlreadyExistsException, InvalidCredentialException, InvalidUserException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException, LicenseExceededException, InvalidInvitationException, MailServerConfigurationException, MailSendException, AddressException, UserNotFoundException, EmailAlreadyExistsException {
        Option<ExpirableUserToken> maybeInvitation = this.invitationService.getInvitation(token);
        if (maybeInvitation.isEmpty()) {
            throw new InvalidInvitationException();
        }
        inputUserEntity.setEmail(((ExpirableUserToken)maybeInvitation.get()).getEmailAddress());
        UserEntity outputUserEntity = this.addUserWithDefaultApplicationAccess(inputUserEntity, baseURI, false);
        this.invitationService.removeToken(token);
        if (this.signupSettingsService.isEmailSentOnSignUp()) {
            User user = this.directoryManager.findUserByName(this.getDirectoryId(), outputUserEntity.getName());
            Map<String, Integer> licenses = UserController.transformKeys(this.getAvailableSeatsForDefaultApplications(), this.APPLICATION_LINK_TO_NAME);
            for (User admin : this.getDirectUsersOfGroup(CROSS_PRODUCT_ADMINS)) {
                this.sendEmailService.sendSignupNotificationEmail(admin.getEmailAddress(), user, licenses, serverName);
            }
        }
        return outputUserEntity;
    }

    private static UserTemplate newUserTemplate(UserEntity userEntity, long directoryId) {
        return UserTemplateBuilder.from(userEntity).withDirectoryId(directoryId).withActive(true).build();
    }

    private static UserTemplate newUserTemplate(String name, String emailAddress, long directoryId) {
        return UserTemplateBuilder.withName(name).withEmailAddress(emailAddress).withDirectoryId(directoryId).withActive(true).build();
    }

    private static <K, V> Map<K, Set<String>> createAttributesMap(K k1, V v1, K k2, V v2) {
        return ImmutableMap.of(k1, Collections.singleton(String.valueOf(v1)), k2, Collections.singleton(String.valueOf(v2)));
    }

    private static <K1, K2, V> Map<K2, V> transformKeys(Map<K1, V> fromMap, Function<? super K1, K2> function) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<K1, V> entry : fromMap.entrySet()) {
            builder.put(function.apply(entry.getKey()), entry.getValue());
        }
        return builder.build();
    }

    public void selfInvite(PublicSignUpFormEntity publicSignUpFormEntity) throws SignupNotEnabledException, EmailNotAllowedException, DirectoryNotFoundException, OperationFailedException, AddressException, MailServerConfigurationException, MailSendException, UserNotFoundException, ObjectAlreadyExistsException, EmailAlreadyExistsException {
        if (!this.signupSettingsService.isSignupEnabled()) {
            throw new SignupNotEnabledException();
        }
        String email = publicSignUpFormEntity.getEmail();
        if (!this.signupSettingsService.isEmailAllowed(email)) {
            throw new EmailNotAllowedException();
        }
        if (this.emailExists(email)) {
            throw new EmailAlreadyExistsException(email);
        }
        String token = this.invitationService.createAndStoreInviteToken(email, SELF_INVITE_EXPIRY_SECONDS);
        this.sendEmailService.sendSignUpEmail(email, token);
    }

    private List<User> getDirectUsersOfGroup(String groupName) throws DirectoryNotFoundException, OperationFailedException {
        return this.directoryManager.searchDirectGroupRelationships(this.getDirectoryId(), QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1));
    }

    public UserEntity addUserWithDefaultApplicationAccess(UserEntity userEntity, URI baseURI, boolean expandAttributes) throws UserAlreadyExistsException, InvalidCredentialException, InvalidUserException, OperationFailedException, DirectoryNotFoundException, DirectoryPermissionException, LicenseExceededException, EmailAlreadyExistsException {
        PasswordCredential credential;
        String email = userEntity.getEmail();
        if (this.emailExists(email)) {
            throw new EmailAlreadyExistsException(email);
        }
        UserProvisioningService.ReservedApplicationAccess reservation = this.reserveDefaultApplicationAccessAnonymously();
        PasswordCredential passwordCredential = credential = userEntity.getPassword() != null && userEntity.getPassword().getValue() != null ? PasswordCredential.unencrypted((String)userEntity.getPassword().getValue()) : PasswordCredential.NONE;
        if (userEntity.getName() == null) {
            String username = (String)Iterables.find(UserController.generateUsernames(userEntity), (Predicate)Predicates.not(this.USERNAME_EXISTS_PREDICATE), null);
            if (username == null) {
                throw new OperationFailedException("Cannot generate a username for the new user");
            }
            userEntity.setName(username);
        }
        UserTemplate userTemplate = UserController.newUserTemplate(userEntity, this.getDirectoryId());
        this.addUser(userTemplate, credential);
        reservation.apply(ImmutableSet.of((Object)userEntity.getName()));
        try {
            return this.userAndGroupService.getUserEntity(userEntity.getName(), baseURI, expandAttributes);
        }
        catch (UserNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    static Iterable<String> generateUsernames(UserEntity userEntity) {
        Preconditions.checkArgument((boolean)StringUtils.isBlank(userEntity.getName()), (Object)"The user entity already specifies a username");
        return UserController.generateUsernames(userEntity.getEmail(), userEntity.getDisplayName());
    }

    private static Iterable<String> generateUsernames(String email, String displayName) {
        ImmutableList.Builder builder = ImmutableList.builder();
        String emailLocalPart = "";
        if (email != null && email.contains("@") && StringUtils.isNotBlank(emailLocalPart = email.split("@")[0])) {
            builder.add((Object)emailLocalPart);
        }
        String normalisedDisplayName = "";
        if (displayName != null && StringUtils.isNotBlank(normalisedDisplayName = displayName.replaceAll("\\W", "").toLowerCase())) {
            builder.add((Object)normalisedDisplayName);
        }
        String prefix = StringUtils.isNotBlank(emailLocalPart) ? emailLocalPart : (StringUtils.isNotBlank(normalisedDisplayName) ? normalisedDisplayName : "user");
        for (int i = 1; i <= 20; ++i) {
            builder.add((Object)(prefix + i));
        }
        builder.add((Object)(prefix + (USERNAME_RANDOM_GENERATOR.nextInt(80) + 20 + 1)));
        builder.add((Object)(prefix + (USERNAME_RANDOM_GENERATOR.nextInt(80) + 20 + 1)));
        builder.add((Object)(prefix + (USERNAME_RANDOM_GENERATOR.nextInt(80) + 20 + 1)));
        builder.add((Object)(prefix + USERNAME_RANDOM_GENERATOR.nextInt(Integer.MAX_VALUE)));
        builder.add((Object)(prefix + USERNAME_RANDOM_GENERATOR.nextInt(Integer.MAX_VALUE)));
        builder.add((Object)(prefix + USERNAME_RANDOM_GENERATOR.nextInt(Integer.MAX_VALUE)));
        return builder.build();
    }

    public void grantDefaultApplicationAccess(String username) throws LicenseExceededException, DirectoryNotFoundException, OperationFailedException, UserNotFoundException {
        this.userAndGroupService.getUser(username);
        FailureUtils.handleMaybeFailures(this.userProvisioningService.grantApplicationAccessAnonymously((Set<String>)ImmutableSet.of((Object)username), this.applicationLinkConfigService.fetchAllConfigsForApplications(this.userProvisioningService.getDefaultApplications())));
    }

    private UserProvisioningService.ReservedApplicationAccess reserveApplicationAccess(Iterable<ReadOnlyApplicationLink> applicationLinks) throws LicenseExceededException {
        return this.reserveApplicationAccess(1, applicationLinks);
    }

    private UserProvisioningService.ReservedApplicationAccess reserveApplicationAccess(int needed, Iterable<ReadOnlyApplicationLink> applicationLinks) throws LicenseExceededException {
        Either<Map<ReadOnlyApplicationLink, Failure>, UserProvisioningService.ReservedApplicationAccess> failureOrReservation = this.userProvisioningService.reserveApplicationAccess(needed, this.applicationLinkConfigService.fetchAllConfigsForApplications(applicationLinks));
        return FailureUtils.handleMaybeFailures(failureOrReservation);
    }

    private UserProvisioningService.ReservedApplicationAccess reserveDefaultApplicationAccessAnonymously() throws LicenseExceededException {
        Iterable<ReadOnlyApplicationLinkWithConfig> defaultApplicationLinks = this.applicationLinkConfigService.fetchAllConfigsForApplications(this.userProvisioningService.getDefaultApplications());
        Either<Map<ReadOnlyApplicationLink, Failure>, UserProvisioningService.ReservedApplicationAccess> failureOrReservation = this.userProvisioningService.reserveApplicationAccessAnonymously(1, defaultApplicationLinks);
        return FailureUtils.handleMaybeFailures(failureOrReservation);
    }

    @VisibleForTesting
    static ImmutableList<User> explicitlyOrderUsersByUsername(List<String> usernames, Iterable<User> users) {
        return UserController.explicitlyOrder(usernames, new Function<User, String>(){

            public String apply(User user) {
                return user.getName();
            }
        }, users);
    }

    @VisibleForTesting
    List<Group> explictlyPrependGroupsByGroupname(List<String> orderedGroupNames, List<Group> initialGroups) throws DirectoryNotFoundException, OperationFailedException, GroupNotFoundException {
        if (orderedGroupNames == null || orderedGroupNames.isEmpty()) {
            return initialGroups;
        }
        ImmutableList.Builder priorityGroups = ImmutableList.builder();
        for (String groupName : orderedGroupNames) {
            priorityGroups.add((Object)this.directoryManager.findGroupByName(this.getDirectoryId(), groupName));
        }
        ImmutableList priorityGroupsList = priorityGroups.build();
        ImmutableList allGroupsInDesiredOrder = ImmutableList.builder().addAll((Iterable)priorityGroupsList).addAll(Iterables.filter(initialGroups, (Predicate)Predicates.not((Predicate)Predicates.in((Collection)priorityGroupsList)))).build();
        return ImmutableList.copyOf((Iterable)Iterables.limit((Iterable)allGroupsInDesiredOrder, (int)initialGroups.size()));
    }

    private static <T, F, E extends F> ImmutableList<E> explicitlyOrder(List<T> valuesInOrder, Function<F, ? extends T> function, Iterable<E> elements) {
        return new ExplicitOrdering<T>(valuesInOrder).onResultOf(function).immutableSortedCopy(elements);
    }

    private static class UserEntityWithAccessControlTransformer
    implements Function<UserWithAttributes, UserEntity> {
        private final Directory directory;
        private final URI baseUri;
        private final UserAndGroupCheckService userAndGroupCheckService;
        private final String groupName;
        private final I18nResolver i18nResolver;

        private UserEntityWithAccessControlTransformer(Directory directory, URI baseUri, UserAndGroupCheckService userAndGroupCheckService, String groupName, I18nResolver i18nResolver) {
            this.directory = directory;
            this.baseUri = baseUri;
            this.userAndGroupCheckService = userAndGroupCheckService;
            this.groupName = groupName;
            this.i18nResolver = i18nResolver;
        }

        public UserEntity apply(UserWithAttributes user) {
            String username = user.getName();
            Link userLink = LinkUriHelper.buildUserLink(this.baseUri, username);
            UserEntity userEntity = EntityTranslator.toUserEntity((User)user, (Attributes)user, userLink);
            userEntity.setDirectoryName(this.directory.getName());
            Option<Message> accessMessage = this.userAndGroupCheckService.canCurrentUserModifyUserAccess(username);
            Option<Message> dataMessage = this.userAndGroupCheckService.canCurrentUserModifyUserData(username);
            String disabledMessage = MessageHelper.getDisabledMessage(accessMessage, dataMessage, this.i18nResolver);
            LozengeEntity lozenge = this.userAndGroupCheckService.getUserLozenge(userEntity).getOrNull();
            return new ListViewUser(userEntity, null, this.unableToModifyAccess(username, accessMessage), this.unableToEdit(username), disabledMessage, lozenge, this.userAndGroupCheckService.isCurrentUser(username));
        }

        private boolean unableToModifyAccess(String username, Option<Message> accessMessage) {
            return accessMessage.isDefined() || this.userAndGroupCheckService.isCurrentUser(username) && this.userAndGroupCheckService.willCurrentUserBeDemotedByLeavingGroup(this.groupName).isDefined();
        }

        private boolean unableToEdit(String username) {
            return this.userAndGroupCheckService.canCurrentUserModifyUserData(username).isDefined();
        }
    }

    private static class UserEntityTransformer
    implements Function<UserWithAttributes, UserEntity> {
        private final Directory directory;
        private final URI baseUri;

        private UserEntityTransformer(Directory directory, URI baseUri) {
            this.directory = directory;
            this.baseUri = baseUri;
        }

        public UserEntity apply(UserWithAttributes user) {
            Link userLink = LinkUriHelper.buildUserLink(this.baseUri, user.getName());
            UserEntity userEntity = EntityTranslator.toUserEntity((User)user, (Attributes)user, userLink);
            userEntity.setDirectoryName(this.directory.getName());
            return userEntity;
        }
    }
}

