/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.controller;

import com.atlassian.crowd.plugin.usermanagement.rest.controller.BaseController;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.SignupOptionsEntity;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.service.SignupSettingsService;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class SignupController
extends BaseController {
    private final SignupSettingsService signupSettingsService;

    public SignupController(DirectoryLocator directoryLocator, I18nResolver i18nResolver, SignupSettingsService signupSettingsService) {
        super(directoryLocator, i18nResolver);
        this.signupSettingsService = signupSettingsService;
    }

    public void setSignupOptions(SignupOptionsEntity signupOptionsEntity) {
        boolean enabled = signupOptionsEntity.isSignupEnabled();
        List domains = (List)Objects.firstNonNull(signupOptionsEntity.getDomains(), (Object)ImmutableList.of());
        boolean notify = signupOptionsEntity.isNotifyAdmin();
        this.signupSettingsService.setSignupEnabled(enabled);
        this.signupSettingsService.setEmailSentOnSignUp(notify);
        if (enabled) {
            this.signupSettingsService.setRestrictedDomains(domains);
        }
    }

    public SignupOptionsEntity getSignupOptions() {
        boolean signupEnabled = this.signupSettingsService.isSignupEnabled();
        List<String> restrictedDomains = this.signupSettingsService.getRestrictedDomains();
        boolean emailSentOnInviteSignUp = this.signupSettingsService.isEmailSentOnSignUp();
        return new SignupOptionsEntity(signupEnabled, restrictedDomains, emailSentOnInviteSignUp);
    }
}

