/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.controller;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.plugin.rest.entity.GroupEntity;
import com.atlassian.crowd.plugin.rest.util.EntityTranslator;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.BaseController;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.GroupEntityWithAccessControl;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupCheckService;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class GroupController
extends BaseController {
    private final DirectoryManager directoryManager;
    private final UserAndGroupCheckService userAndGroupCheckService;

    public GroupController(DirectoryManager directoryManager, DirectoryLocator directoryLocator, UserAndGroupCheckService userAndGroupCheckService, I18nResolver i18nResolver) {
        super(directoryLocator, i18nResolver);
        this.userAndGroupCheckService = userAndGroupCheckService;
        this.directoryManager = (DirectoryManager)Preconditions.checkNotNull((Object)directoryManager);
    }

    public GroupEntity getGroup(String groupName, URI baseUri) throws DirectoryNotFoundException, GroupNotFoundException, OperationFailedException {
        Preconditions.checkNotNull((Object)groupName);
        Group group = this.getGroupByName(groupName);
        boolean isUnmodifiable = this.userAndGroupCheckService.canCurrentUserModifyGroup(groupName).isDefined();
        boolean isLastAdminGroup = this.userAndGroupCheckService.willCurrentUserBeDemotedByLeavingGroup(groupName).isDefined();
        return GroupEntityWithAccessControl.newGroupEntityWithAccessControl(group.getName(), group.getDescription(), group.isActive(), isUnmodifiable, isLastAdminGroup, baseUri);
    }

    private Group getGroupByName(String groupName) throws GroupNotFoundException, DirectoryNotFoundException, OperationFailedException {
        return this.directoryManager.findGroupByName(this.getDirectoryId(), groupName);
    }

    public Iterable<GroupEntity> findGroupsByName(@Nullable String nameFilter, int startIndex, int maxResults, URI baseUri) throws DirectoryNotFoundException, OperationFailedException {
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with(this.groupRestriction(nameFilter)).startingAt(startIndex).returningAtMost(maxResults);
        List groups = this.directoryManager.searchGroups(this.getDirectoryId(), query);
        return Lists.transform((List)groups, (Function)GroupController.toGroupEntityWithAccessControl(baseUri, this.userAndGroupCheckService));
    }

    public GroupEntity addGroup(GroupEntity group, URI baseURI) throws DirectoryNotFoundException, OperationFailedException, DirectoryPermissionException, InvalidGroupException {
        GroupTemplate groupTemplate = new GroupTemplate(group.getName(), this.getDirectoryId(), GroupType.GROUP);
        groupTemplate.setActive(group.isActive() == null ? true : group.isActive());
        groupTemplate.setDescription(group.getDescription());
        return EntityTranslator.toGroupEntity(this.directoryManager.addGroup(this.getDirectoryId(), groupTemplate), baseURI);
    }

    public GroupEntity updateGroup(GroupEntity group, URI baseUri) throws InvalidGroupException, GroupNotFoundException, DirectoryNotFoundException, DirectoryPermissionException, OperationFailedException, ReadOnlyGroupException {
        GroupTemplate groupTemplate = new GroupTemplate(group.getName(), this.getDirectoryId(), GroupType.GROUP);
        groupTemplate.setDescription(group.getDescription());
        groupTemplate.setActive(group.isActive() == null ? true : group.isActive());
        return EntityTranslator.toGroupEntity(this.directoryManager.updateGroup(this.getDirectoryId(), groupTemplate), baseUri);
    }

    private SearchRestriction groupRestriction(String name) {
        if (StringUtils.isEmpty(name)) {
            return NullRestrictionImpl.INSTANCE;
        }
        return Restriction.on((Property)GroupTermKeys.NAME).containing((Object)name);
    }

    private static GroupEntityWithAccessControlTransformer toGroupEntityWithAccessControl(URI baseUri, UserAndGroupCheckService userAndGroupCheckService) {
        return new GroupEntityWithAccessControlTransformer(baseUri, userAndGroupCheckService);
    }

    private static class GroupEntityWithAccessControlTransformer
    implements Function<Group, GroupEntity> {
        private final URI baseUri;
        private final UserAndGroupCheckService userAndGroupCheckService;

        private GroupEntityWithAccessControlTransformer(URI baseUri, UserAndGroupCheckService userAndGroupCheckService) {
            this.baseUri = baseUri;
            this.userAndGroupCheckService = userAndGroupCheckService;
        }

        public GroupEntity apply(Group group) {
            return GroupEntityWithAccessControl.newGroupEntityWithAccessControl(group.getName(), group.getDescription(), group.isActive(), this.userAndGroupCheckService.canCurrentUserModifyGroup(group.getName()).isDefined(), this.userAndGroupCheckService.willCurrentUserBeDemotedByLeavingGroup(group.getName()).isDefined(), this.baseUri);
        }
    }
}

