/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.controller;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.AccessLevel;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.util.ImmutableMapUtils;
import com.atlassian.crowd.plugin.usermanagement.util.ApplicationLinkFunctions;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import java.util.Map;

public abstract class BaseController {
    protected final DirectoryLocator directoryLocator;
    protected final I18nResolver i18nResolver;

    public BaseController(DirectoryLocator directoryLocator, I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
        this.directoryLocator = (DirectoryLocator)Preconditions.checkNotNull((Object)directoryLocator);
    }

    protected long getDirectoryId() {
        return this.directoryLocator.getDirectoryId();
    }

    protected Map<String, AccessLevel> translateAccessLevelRepresentation(Map<ReadOnlyApplicationLink, AccessLevel> accessLevel) {
        return ImmutableMapUtils.transformKey(accessLevel, ApplicationLinkFunctions.APPLICATION_LINK_STRING_ID_GETTER);
    }
}

