/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.rest.controller;

import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.controller.BaseController;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ApplicationDefaultsEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ApplicationEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.ApplicationLicenseInfoEntity;
import com.atlassian.crowd.plugin.usermanagement.rest.entity.SeatsEntity;
import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkConfigService;
import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkFilteringService;
import com.atlassian.crowd.plugin.usermanagement.service.DirectoryLocator;
import com.atlassian.crowd.plugin.usermanagement.service.ReadOnlyApplicationLinkWithConfig;
import com.atlassian.crowd.plugin.usermanagement.service.UserAndGroupCheckService;
import com.atlassian.crowd.plugin.usermanagement.service.UserProvisioningService;
import com.atlassian.crowd.plugin.usermanagement.service.validation.ApplicationAccessError;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.ApplicationUsageEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.ConfigurationEntity;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.util.ImmutableMapUtils;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ApplicationController
extends BaseController {
    private final DirectoryManager directoryManager;
    private final ApplicationLinkFilteringService applicationLinkFilteringService;
    private final UserProvisioningService userProvisioningService;
    private final UserAndGroupCheckService userAndGroupCheckService;
    private final ApplicationLinkConfigService applicationLinkConfigService;

    public ApplicationController(DirectoryLocator directoryLocator, DirectoryManager directoryManager, ApplicationLinkFilteringService applicationLinkFilteringService, I18nResolver i18nResolver, UserProvisioningService userProvisioningService, UserAndGroupCheckService userAndGroupCheckService, ApplicationLinkConfigService applicationLinkConfigService) {
        super(directoryLocator, i18nResolver);
        this.directoryManager = directoryManager;
        this.applicationLinkFilteringService = applicationLinkFilteringService;
        this.userProvisioningService = userProvisioningService;
        this.userAndGroupCheckService = userAndGroupCheckService;
        this.applicationLinkConfigService = applicationLinkConfigService;
    }

    public List<ApplicationLicenseInfoEntity> getApplicationLicenseEntities() throws DirectoryNotFoundException, OperationFailedException, CredentialsRequiredException {
        ImmutableList.Builder licenseListBuilder = ImmutableList.builder();
        for (ApplicationDefaultsEntity application : this.getApplicationDefaults()) {
            ApplicationLicenseInfoEntity.ApplicationLicenseInfoEntityBuilder licenseBuilder = ApplicationLicenseInfoEntity.builder(application);
            Either<ApplicationAccessError, SeatsEntity> errorOrAvailableSeats = this.getSeatsEntityForApplication(application.getId());
            if (errorOrAvailableSeats.isRight()) {
                SeatsEntity seatsEntity = (SeatsEntity)errorOrAvailableSeats.right().get();
                licenseBuilder.withSeatsTaken(Option.some(seatsEntity.getUsed())).withSeatsAvailable(seatsEntity.getAvailable()).withIsUnlimited(Option.some(seatsEntity.isUnlimited()));
            } else {
                licenseBuilder.withError(errorOrAvailableSeats.left().toOption());
            }
            licenseListBuilder.add((Object)licenseBuilder.build());
        }
        return licenseListBuilder.build();
    }

    public List<ApplicationUsageEntity> getApplicationUsage() throws DirectoryNotFoundException, OperationFailedException, CredentialsRequiredException {
        List<ApplicationLicenseInfoEntity> applicationLicenseInfoEntities = this.getApplicationLicenseEntities();
        List applicationUsageList = Lists.transform(applicationLicenseInfoEntities, (Function)new Function<ApplicationLicenseInfoEntity, ApplicationUsageEntity>(){

            public ApplicationUsageEntity apply(ApplicationLicenseInfoEntity applicationLicenseInfoEntity) {
                if (applicationLicenseInfoEntity.getError() == null) {
                    return new ApplicationUsageEntity(applicationLicenseInfoEntity.getName().toUpperCase(), applicationLicenseInfoEntity.getSeatsTaken());
                }
                return new ApplicationUsageEntity(applicationLicenseInfoEntity.getName().toUpperCase(), applicationLicenseInfoEntity.getError().getReason());
            }
        });
        return applicationUsageList;
    }

    public Iterable<ApplicationDefaultsEntity> getApplicationDefaults() {
        return Iterables.transform(this.userProvisioningService.getApplicationDefaults().entrySet(), (Function)new Function<Map.Entry<ReadOnlyApplicationLink, Boolean>, ApplicationDefaultsEntity>(){

            public ApplicationDefaultsEntity apply(Map.Entry<ReadOnlyApplicationLink, Boolean> entry) {
                return ApplicationController.this.newApplicationDefaultsEntity(entry.getKey(), entry.getValue());
            }
        });
    }

    private ApplicationDefaultsEntity newApplicationDefaultsEntity(ReadOnlyApplicationLink applicationLink, boolean isDefault) {
        return new ApplicationDefaultsEntity(ApplicationEntity.fromApplicationLink(applicationLink, this.i18nResolver), isDefault);
    }

    public Iterable<ApplicationDefaultsEntity> updateApplicationDefaults(Map<String, Boolean> applicationIds) {
        this.userProvisioningService.updateApplicationDefaults((Map<ReadOnlyApplicationLink, Boolean>)ImmutableMapUtils.collectByKey(ImmutableMapUtils.transformKey(applicationIds, new Function<String, Option<ReadOnlyApplicationLink>>(){

            public Option<ReadOnlyApplicationLink> apply(String id) {
                return ApplicationController.this.applicationLinkFilteringService.getApplicationLink(id);
            }
        }), Functions.identity()));
        return this.getApplicationDefaults();
    }

    public List<ApplicationEntity> getApplications() {
        return ImmutableList.copyOf((Iterable)Iterables.transform(this.applicationLinkFilteringService.getApplicationLinks(), (Function)new Function<ReadOnlyApplicationLink, ApplicationEntity>(){

            public ApplicationEntity apply(ReadOnlyApplicationLink application) {
                return ApplicationEntity.fromApplicationLink(application, ApplicationController.this.i18nResolver);
            }
        }));
    }

    private Either<ApplicationAccessError, SeatsEntity> getSeatsEntityForApplication(String applicationLinkId) throws DirectoryNotFoundException, OperationFailedException {
        Option<ReadOnlyApplicationLink> maybeAppLink = this.applicationLinkFilteringService.getApplicationLink(applicationLinkId);
        if (maybeAppLink.isDefined()) {
            ReadOnlyApplicationLinkWithConfig appLink = this.applicationLinkConfigService.fetchConfigForApplication((ReadOnlyApplicationLink)maybeAppLink.get());
            if (appLink.getConfig().isRight()) {
                return Either.right(this.userProvisioningService.getSeatsEntityForApplication((ConfigurationEntity)appLink.getConfig().right().get()));
            }
            return Either.left(appLink.getConfig().left().get());
        }
        return Either.left(new ApplicationAccessError(this.i18nResolver.getText("usermanagement.apps.notfound.error")));
    }

    /*
     * Exception decompiling
     */
    public Collection<UserEntity> getUsersWithAccessToApplication(String filter, String applicationLinkId, int startIndex, int maxResults, List<String> usernamesToPrepend, URI baseUri) throws CredentialsRequiredException, DirectoryNotFoundException, OperationFailedException, UserNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Predicate<ReadOnlyApplicationLink> hasId(final String applicationLinkId) {
        return new Predicate<ReadOnlyApplicationLink>(){

            public boolean apply(ReadOnlyApplicationLink applicationLink) {
                return applicationLink.getId().get().equals(applicationLinkId);
            }
        };
    }

    @VisibleForTesting
    static Ordering<User> rearrangeUsers(final List<String> usernamesToPrepend) {
        return Ordering.explicit(usernamesToPrepend).nullsLast().onResultOf((Function)new Function<User, String>(){

            public String apply(User user) {
                String name = user.getName();
                return usernamesToPrepend.contains(name) ? name : null;
            }
        });
    }

    private static <T extends User> Predicate<T> userMatchesFilter(String filter) {
        if (filter.isEmpty()) {
            return Predicates.alwaysTrue();
        }
        final String normalisedFilter = filter.trim().toLowerCase();
        return new Predicate<T>(){

            public boolean apply(T user) {
                return StringUtils.containsIgnoreCase(user.getEmailAddress(), normalisedFilter) || StringUtils.containsIgnoreCase(user.getDisplayName(), normalisedFilter) || StringUtils.containsIgnoreCase(user.getName(), normalisedFilter);
            }
        };
    }

    private static <T extends User> Predicate<T> userIsActive() {
        return new Predicate<T>(){

            public boolean apply(T user) {
                return user.isActive();
            }
        };
    }
}

