/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.feature;

import com.atlassian.crowd.plugin.usermanagement.feature.FeatureGuard;
import com.atlassian.crowd.plugin.usermanagement.feature.FeatureGuardFilter;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.sun.jersey.api.core.InjectParam;
import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import java.util.List;
import javax.ws.rs.ext.Provider;

@Provider
public class FeatureGuardFilterFactory
implements ResourceFilterFactory {
    private final DarkFeatureManager darkFeatureManager;

    public FeatureGuardFilterFactory(@InjectParam(value="darkFeatureManager") DarkFeatureManager darkFeatureManager) {
        this.darkFeatureManager = darkFeatureManager;
    }

    public List<ResourceFilter> create(AbstractMethod method) {
        FeatureGuard methodAnnotation = (FeatureGuard)method.getAnnotation(FeatureGuard.class);
        FeatureGuard classAnnotation = (FeatureGuard)method.getResource().getAnnotation(FeatureGuard.class);
        return Option.option(methodAnnotation).orElse(Option.option(classAnnotation)).map(new ToFilter()).getOrElse(FeatureGuardFilterFactory.noFilters());
    }

    private static ImmutableList<ResourceFilter> noFilters() {
        return ImmutableList.of();
    }

    private class ToFilter
    implements Function<FeatureGuard, List<ResourceFilter>> {
        private ToFilter() {
        }

        public List<ResourceFilter> apply(FeatureGuard featureGuard) {
            return ImmutableList.of((Object)new FeatureGuardFilter(FeatureGuardFilterFactory.this.darkFeatureManager, featureGuard));
        }
    }
}

