/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.usermanagement.common;

import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.crowd.plugin.usermanagement.common.AppLinkResult;
import com.atlassian.crowd.plugin.usermanagement.common.AppLinkResultImpl;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppLinkJSON {
    private static final Logger log = LoggerFactory.getLogger(AppLinkJSON.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private static ObjectWriter writer = mapper.writer();

    public static <R> R get(Class<? extends R> type, ReadOnlyApplicationLink link, String endpoint) throws Exception {
        return AppLinkJSON.getResult(type, link, endpoint).getContent();
    }

    public static <R> R getQuietly(Class<? extends R> entity, ReadOnlyApplicationLink link, String endpoint) {
        return AppLinkJSON.execute(entity, link, Request.MethodType.GET, endpoint, null).getContent();
    }

    public static <R> AppLinkResult<R> getResultQuietly(Class<? extends R> entity, ReadOnlyApplicationLink link, String endpoint) {
        return AppLinkJSON.execute(entity, link, Request.MethodType.GET, endpoint, null);
    }

    public static <R> AppLinkResult<R> getResult(Class<? extends R> entity, ReadOnlyApplicationLink link, String endpoint) throws Exception {
        AppLinkResult<R> result = AppLinkJSON.getResultQuietly(entity, link, endpoint);
        if (result.hasException()) {
            throw result.getException();
        }
        return result;
    }

    public static AppLinkResult<Void> put(ReadOnlyApplicationLink link, String endpoint) throws Exception {
        AppLinkResult<Void> result = AppLinkJSON.putQuietly(link, endpoint);
        if (result.hasException()) {
            throw result.getException();
        }
        return result;
    }

    public static AppLinkResult<Void> putQuietly(ReadOnlyApplicationLink link, String endpoint) throws Exception {
        return AppLinkJSON.execute(Void.class, link, Request.MethodType.PUT, endpoint, null);
    }

    public static <R> AppLinkResult<R> put(R entity, ReadOnlyApplicationLink link, String endpoint) throws Exception {
        AppLinkResult<R> result = AppLinkJSON.putQuietly(entity, link, endpoint);
        if (result.hasException()) {
            throw result.getException();
        }
        return result;
    }

    public static <R> AppLinkResult<R> putQuietly(R entity, ReadOnlyApplicationLink link, String endpoint) {
        return AppLinkJSON.execute(entity.getClass(), link, Request.MethodType.PUT, endpoint, entity);
    }

    private static <R> AppLinkResult<R> execute(final Class<? extends R> type, ReadOnlyApplicationLink link, final Request.MethodType mode, String endpoint, R entity) {
        final AppLinkResultImpl result = new AppLinkResultImpl();
        try {
            if (link != null) {
                String target = link.getRpcUrl() + endpoint;
                result.setTarget(target);
                result.setMethodType(mode);
                try {
                    ApplicationLinkRequest request = link.createAuthenticatedRequestFactory().createRequest(mode, target);
                    if (mode == Request.MethodType.PUT && entity != null) {
                        request.setRequestContentType("application/json");
                        request.setRequestBody(writer.writeValueAsString(entity));
                    }
                    request.execute((ResponseHandler)new ResponseHandler<Response>(){

                        public void handle(Response response) throws ResponseException {
                            result.setResponse(response);
                            if (response.getStatusCode() == 200) {
                                if (mode == Request.MethodType.GET) {
                                    Object content = response.getEntity(type);
                                    result.set(content);
                                }
                            } else {
                                result.setException(new Exception("Error occurred: " + response.getStatusText()));
                            }
                        }
                    });
                }
                catch (Exception e) {
                    result.setException(e);
                }
            } else {
                result.setException(new Exception("link unavailable"));
            }
        }
        catch (Exception e) {
            result.setException(e);
        }
        log.debug(result.toString());
        return result;
    }
}

