/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationAccessDeniedException;
import com.atlassian.crowd.manager.authentication.TokenAuthenticationManager;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.token.TokenLifetime;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.plugin.rest.entity.SessionEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.entity.ValidationFactorEntity;
import com.atlassian.crowd.plugin.rest.util.EntityTranslator;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.plugins.rest.common.Link;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;

public class TokenController {
    private final TokenAuthenticationManager tokenAuthenticationManager;

    public TokenController(TokenAuthenticationManager tokenAuthenticationManager) {
        this.tokenAuthenticationManager = tokenAuthenticationManager;
    }

    public SessionEntity authenticateUser(String applicationName, String username, String password, TokenLifetime tokenDuration, Collection<ValidationFactorEntity> validationFactorEntities, URI baseUri) throws InvalidAuthenticationException, InactiveAccountException, ExpiredCredentialException, ApplicationAccessDeniedException, OperationFailedException {
        Token token;
        ValidationFactor[] validationFactors = TokenController.convertToValidationFactors(validationFactorEntities);
        UserAuthenticationContext authenticationContext = new UserAuthenticationContext(username, PasswordCredential.unencrypted((String)password), validationFactors, applicationName);
        try {
            token = this.tokenAuthenticationManager.authenticateUser(authenticationContext, tokenDuration);
        }
        catch (ApplicationNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return this.createSessionEntityWithMinimalUser(token, applicationName, baseUri);
    }

    public SessionEntity authenticateUserWithoutValidatingPassword(String applicationName, String username, Collection<ValidationFactorEntity> validationFactorEntities, URI baseUri) throws InvalidAuthenticationException, InactiveAccountException, ExpiredCredentialException, ApplicationAccessDeniedException, OperationFailedException {
        Token token;
        ValidationFactor[] validationFactors = TokenController.convertToValidationFactors(validationFactorEntities);
        UserAuthenticationContext authenticationContext = new UserAuthenticationContext(username, null, validationFactors, applicationName);
        try {
            token = this.tokenAuthenticationManager.authenticateUserWithoutValidatingPassword(authenticationContext);
        }
        catch (ApplicationNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return this.createSessionEntityWithMinimalUser(token, applicationName, baseUri);
    }

    public void invalidateToken(String token) {
        this.tokenAuthenticationManager.invalidateToken(token);
    }

    public SessionEntity validateToken(String applicationName, String token, Collection<ValidationFactorEntity> validationFactorEntities, URI baseUri) throws InvalidTokenException, ApplicationAccessDeniedException, OperationFailedException {
        ValidationFactor[] validationFactors = TokenController.convertToValidationFactors(validationFactorEntities);
        Token validatedToken = this.tokenAuthenticationManager.validateUserToken(token, validationFactors, applicationName);
        return this.createSessionEntityWithMinimalUser(validatedToken, applicationName, baseUri);
    }

    private User getUserFromToken(String token, String applicationName, URI baseUri) throws InvalidTokenException, OperationFailedException, ApplicationAccessDeniedException {
        User user;
        try {
            user = this.tokenAuthenticationManager.findUserByToken(token, applicationName);
        }
        catch (ApplicationNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return user;
    }

    public SessionEntity getSessionFromToken(String tokenKey, String applicationName, URI baseUri) throws InvalidTokenException, OperationFailedException, ApplicationAccessDeniedException {
        Token token;
        User user = this.getUserFromToken(tokenKey, applicationName, baseUri);
        try {
            token = this.tokenAuthenticationManager.findUserTokenByKey(tokenKey, applicationName);
        }
        catch (ApplicationNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return this.createSessionEntityWithExpandedUser(token, user, baseUri);
    }

    private SessionEntity createSessionEntity(String randomHash, UserEntity userEntity, Link link, Token token) {
        String unaliasedUsername = token.getUnaliasedUsername();
        if (unaliasedUsername.equals(token.getName())) {
            return new SessionEntity(randomHash, userEntity, link, token.getCreatedDate(), this.tokenAuthenticationManager.getTokenExpiryTime(token));
        }
        return new SessionEntity(randomHash, userEntity, link, token.getCreatedDate(), this.tokenAuthenticationManager.getTokenExpiryTime(token), unaliasedUsername);
    }

    private SessionEntity createSessionEntityWithExpandedUser(Token token, User user, URI baseUri) {
        String username = token.getName();
        String randomHash = token.getRandomHash();
        Link userLink = LinkUriHelper.buildUserLink(baseUri, username);
        UserEntity userEntity = EntityTranslator.toUserEntity(user, userLink);
        Link link = LinkUriHelper.buildSessionLink(baseUri, randomHash);
        return this.createSessionEntity(randomHash, userEntity, link, token);
    }

    private SessionEntity createSessionEntityWithMinimalUser(Token token, String applicationName, URI baseUri) {
        String username = token.getName();
        String randomHash = token.getRandomHash();
        Link userLink = LinkUriHelper.buildUserLink(baseUri, username);
        UserEntity userEntity = UserEntity.newMinimalUserEntity(username, applicationName, userLink);
        Link link = LinkUriHelper.buildSessionLink(baseUri, randomHash);
        return this.createSessionEntity(randomHash, userEntity, link, token);
    }

    private static ValidationFactor[] convertToValidationFactors(Collection<ValidationFactorEntity> validationFactorEntities) {
        ArrayList<ValidationFactor> validationFactors = new ArrayList<ValidationFactor>(validationFactorEntities.size());
        for (ValidationFactorEntity factor : validationFactorEntities) {
            validationFactors.add(new ValidationFactor(factor.getName(), factor.getValue()));
        }
        return validationFactors.toArray(new ValidationFactor[validationFactors.size()]);
    }

    public void invalidateTokensForUser(String username, String exclusionToken, String applicationName) throws UserNotFoundException, ApplicationNotFoundException {
        this.tokenAuthenticationManager.invalidateTokensForUser(username, exclusionToken, applicationName);
    }
}

