/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller;

import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.group.ImmutableMembership;
import com.atlassian.crowd.model.group.Membership;
import com.atlassian.crowd.plugin.rest.service.controller.AbstractResourceController;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.codec.binary.Base64;

public class MembershipsController
extends AbstractResourceController {
    private static final EntityQuery<String> ALL_GROUPS_QUERY = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);

    public MembershipsController(ApplicationService applicationService, ApplicationManager applicationManager) {
        super(applicationService, applicationManager);
    }

    public StreamingOutput asXml(Iterable<? extends Membership> memberships) {
        return new OutputAsXml(memberships);
    }

    public StreamingOutput searchGroups(String applicationName) {
        return this.asXml(this.getMemberships(applicationName));
    }

    public Iterable<Membership> getMemberships(String applicationName) {
        final Application application = this.getApplication(applicationName);
        return Iterables.transform((Iterable)this.applicationService.searchGroups(application, ALL_GROUPS_QUERY), (Function)new Function<String, Membership>(){

            public Membership apply(String groupName) {
                MembershipQuery userNames = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(0).returningAtMost(-1);
                MembershipQuery childGroupNames = QueryBuilder.createMembershipQuery((int)-1, (int)0, (boolean)true, (EntityDescriptor)EntityDescriptor.group(), String.class, (EntityDescriptor)EntityDescriptor.group(), (String)groupName);
                return new ImmutableMembership(groupName, (Iterable)MembershipsController.this.applicationService.searchDirectGroupRelationships(application, userNames), (Iterable)MembershipsController.this.applicationService.searchDirectGroupRelationships(application, childGroupNames));
            }
        });
    }

    void writeXmlToStream(Iterable<? extends Membership> memberships, OutputStream output) throws IOException, XMLStreamException {
        XMLStreamWriter sw = XMLOutputFactory.newInstance().createXMLStreamWriter(output, "utf-8");
        sw.writeStartDocument("utf-8", "1.0");
        sw.writeCharacters("\n");
        sw.writeStartElement("memberships");
        sw.writeCharacters("\n");
        for (Membership membership : memberships) {
            sw.writeCharacters(" ");
            sw.writeStartElement("membership");
            sw.writeAttribute("group", membership.getGroupName());
            sw.writeCharacters("\n");
            sw.writeCharacters("  ");
            sw.writeStartElement("users");
            sw.writeCharacters("\n");
            for (String user : membership.getUserNames()) {
                sw.writeCharacters("   ");
                sw.writeEmptyElement("user");
                sw.writeAttribute("name", user);
                sw.writeCharacters("\n");
            }
            sw.writeCharacters("  ");
            sw.writeEndElement();
            sw.writeCharacters("\n");
            sw.writeCharacters("  ");
            sw.writeStartElement("groups");
            sw.writeCharacters("\n");
            for (String childGroup : membership.getChildGroupNames()) {
                sw.writeCharacters("   ");
                sw.writeEmptyElement("group");
                sw.writeAttribute("name", childGroup);
                sw.writeCharacters("\n");
            }
            sw.writeCharacters("  ");
            sw.writeEndElement();
            sw.writeCharacters("\n");
            sw.writeCharacters(" ");
            sw.writeEndElement();
            sw.writeCharacters("\n");
        }
        sw.writeEndElement();
        sw.writeEndDocument();
        sw.close();
    }

    public static List<ImmutableMembership> copyOf(Iterable<? extends Membership> memberships) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(memberships, (Function)new Function<Membership, ImmutableMembership>(){

            public ImmutableMembership apply(Membership input) {
                return new ImmutableMembership(input.getGroupName(), (Iterable)input.getUserNames(), (Iterable)input.getChildGroupNames());
            }
        }));
    }

    public static String tagFor(Iterable<? extends Membership> memberships) throws NoSuchAlgorithmException {
        TreeMap<String, Membership> ms = new TreeMap<String, Membership>();
        for (Membership membership : memberships) {
            if (ms.put(membership.getGroupName(), membership) == null) continue;
            throw new IllegalArgumentException("Duplicate group name: " + membership.getGroupName());
        }
        MessageDigest md = MessageDigest.getInstance("md5");
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        for (Membership m : ms.values()) {
            md.update((byte)1);
            MembershipsController.addString(byteBuffer, md, m.getGroupName());
            for (String u : MembershipsController.sorted(m.getUserNames())) {
                md.update((byte)2);
                MembershipsController.addString(byteBuffer, md, u);
            }
            for (String g : MembershipsController.sorted(m.getChildGroupNames())) {
                md.update((byte)3);
                MembershipsController.addString(byteBuffer, md, g);
            }
        }
        return Base64.encodeBase64String(md.digest());
    }

    private static Iterable<String> sorted(Set<String> names) {
        return ImmutableSortedSet.copyOf(names);
    }

    private static void addString(ByteBuffer bb, MessageDigest md, String s) {
        bb.position(0);
        bb.putInt(s.length());
        bb.flip();
        md.update(bb);
        md.update(Charsets.UTF_8.encode(s));
    }

    class OutputAsXml
    implements StreamingOutput {
        private final Iterable<? extends Membership> memberships;

        public OutputAsXml(Iterable<? extends Membership> memberships) {
            this.memberships = memberships;
        }

        public void write(OutputStream output) throws IOException, WebApplicationException {
            try {
                MembershipsController.this.writeXmlToStream(this.memberships, output);
            }
            catch (XMLStreamException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
    }
}

