/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.productconfig.rest.resource;

import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.crowd.plugin.rest.service.util.AuthenticatedApplicationUtil;
import com.atlassian.crowd.plugin.usermanagement.common.AppLinkJSON;
import com.atlassian.crowd.plugin.usermanagement.feature.FeatureGuard;
import com.atlassian.crowd.plugin.usermanagement.rest.exception.PermissionDeniedException;
import com.atlassian.crowd.plugin.usermanagement.rest.resource.BaseResource;
import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkFilteringService;
import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkProductService;
import com.atlassian.crowd.plugin.usermanagement.service.ApplicationLinkProductServiceImpl;
import com.atlassian.crowd.plugin.usermanagement.userprovisioning.entity.host.HostEntity;
import com.atlassian.crowd.plugin.usermanagement.util.ResponseFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import java.net.URLDecoder;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="config")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@AnonymousAllowed
@FeatureGuard(value="um.renaissance")
public class ConfigResource
extends BaseResource {
    private static final Logger log = LoggerFactory.getLogger(ConfigResource.class);
    private I18nResolver i18nResolver;
    private ApplicationLinkProductService productService;
    private ApplicationLinkFilteringService applicationLinkService;

    public ConfigResource(I18nResolver i18nResolver, ApplicationLinkFilteringService applicationLinkService, ApplicationLinkProductServiceImpl applicationLinkProductService) {
        this.i18nResolver = i18nResolver;
        this.applicationLinkService = applicationLinkService;
        this.productService = applicationLinkProductService;
    }

    @GET
    @Path(value="products")
    public Response getConfiguration(@QueryParam(value="hostid") String hostID) throws Exception {
        if (hostID != null) {
            String decodedHostID = URLDecoder.decode(hostID, "UTF-8");
            log.debug("ConfigResource - get configuration: " + hostID);
            if (this.productService.contains(decodedHostID)) {
                return ResponseFactory.ok().entity((Object)this.productService.get(decodedHostID)).build();
            }
        }
        return ResponseFactory.serverError().build();
    }

    @PUT
    @Path(value="products")
    public Response setConfiguration(HostEntity entity) throws Exception {
        String authenticatedApplication = AuthenticatedApplicationUtil.getAuthenticatedApplication(this.request);
        if (StringUtils.isEmpty(authenticatedApplication)) {
            throw new PermissionDeniedException();
        }
        log.debug("ConfigResource - setting: " + new ObjectMapper().writeValueAsString((Object)entity));
        if (this.productService.put(entity)) {
            return Response.noContent().build();
        }
        log.error("Unable to set configuration: " + new ObjectMapper().writeValueAsString((Object)entity));
        return Response.serverError().build();
    }

    @GET
    @Path(value="trigger")
    public Response triggerGet() throws Exception {
        return this.trigger();
    }

    @PUT
    @Path(value="trigger")
    public Response trigger() throws Exception {
        log.debug("ConfigResource - trigger synchronization");
        for (ReadOnlyApplicationLink link : this.applicationLinkService.getApplicationLinks()) {
            for (String hostID : this.productService.getHostIDs()) {
                if (!this.hasBaseURL(hostID, link)) continue;
                AppLinkJSON.put(link, "/rest/userprovisioning/latest/synchronize");
            }
        }
        return Response.ok().build();
    }

    private boolean hasBaseURL(String baseURL, ReadOnlyApplicationLink link) {
        String displayURL = link.getDisplayUrl().getAuthority() + link.getDisplayUrl().getPath();
        String rpcURL = link.getRpcUrl().getAuthority() + link.getRpcUrl().getPath();
        return baseURL.equals(displayURL) || baseURL.equals(rpcURL);
    }
}

