/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.adminchrome.data.httpjson.registryurl.impl;

import com.atlassian.crowd.plugin.adminchrome.data.httpjson.registryurl.ComponentRegistryUrlManager;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import javax.annotation.Nonnull;

public class ComponentRegistryUrlManagerImpl
implements ComponentRegistryUrlManager {
    @VisibleForTesting
    static final String DEFAULT_URL = "https://s3.amazonaws.com/common-admin-cdn/unified-admin-chrome/prod/registeredComponents.json";
    @VisibleForTesting
    static final String SYSTEM_PROPERTY_OVERRIDE_KEY = "unified.admin.chrome.registered.components.url";
    private static final String ADMIN_CHROME_PLUGIN_SETTINGS_KEY = "com.atlassian.crowd.plugin.adminchrome:";
    private static final String OVERRIDDEN_HTTP_JSON_URL = "com.atlassian.crowd.plugin.adminchrome:url";
    private final String defaultUrl;
    private final PluginSettings pluginSettings;

    public ComponentRegistryUrlManagerImpl(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.defaultUrl = ComponentRegistryUrlManagerImpl.resolveDefaultUrl();
    }

    @Override
    @Nonnull
    public String resolveEffectiveComponentRegistryUrl() {
        return (String)Objects.firstNonNull((Object)this.getComponentRegistryUrlOverride(), (Object)this.defaultUrl);
    }

    @Override
    public String getComponentRegistryUrlOverride() {
        return (String)this.pluginSettings.get(OVERRIDDEN_HTTP_JSON_URL);
    }

    @Override
    public void setComponentRegistryUrlOverride(String urlOverride) {
        this.pluginSettings.put(OVERRIDDEN_HTTP_JSON_URL, (Object)urlOverride);
    }

    @Override
    public void removeComponentRegistryUrlOverride() {
        this.pluginSettings.remove(OVERRIDDEN_HTTP_JSON_URL);
    }

    private static String resolveDefaultUrl() {
        return System.getProperty(SYSTEM_PROPERTY_OVERRIDE_KEY, DEFAULT_URL);
    }
}

